/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import snownee.jade.JadeClient;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.test.ExamplePlugin;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JsonConfig;

public class Jade {
    public static final String ID = "jade";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final JsonConfig<WailaConfig.Root> rootConfig = new JsonConfig<WailaConfig.Root>("jade/jade", WailaConfig.Root.CODEC, WailaConfig::fixData);
    private static List<JsonConfig<? extends WailaConfig>> configs = List.of();
    private static boolean frozen;

    private static JsonConfig<? extends WailaConfig> configHolder() {
        WailaConfig.Root root = Jade.rootConfig();
        if (root.isEnableProfiles() && root.profileIndex > 0 && root.profileIndex < configs.size()) {
            return configs.get(root.profileIndex);
        }
        return rootConfig;
    }

    public static WailaConfig config() {
        return Jade.configHolder().get();
    }

    public static void saveConfig() {
        Jade.configHolder().save();
        if (Jade.config() != Jade.rootConfig()) {
            rootConfig.save();
        }
    }

    public static void invalidateConfig() {
        Jade.configHolder().invalidate();
    }

    public static WailaConfig.History history() {
        return Jade.rootConfig().history;
    }

    public static void resetConfig() {
        Jade.rootConfig().setEnableProfiles(false);
        int themesHash = Jade.history().themesHash;
        Preconditions.checkState((boolean)rootConfig.getFile().delete());
        Jade.invalidateConfig();
        Jade.history().themesHash = themesHash;
        rootConfig.save();
    }

    public static WailaConfig.Root rootConfig() {
        return rootConfig.get();
    }

    public static void loadComplete() {
        if (frozen) {
            return;
        }
        frozen = true;
        if (CommonProxy.isDevEnv()) {
            try {
                ExamplePlugin plugin = new ExamplePlugin();
                plugin.register(WailaCommonRegistration.instance());
                if (CommonProxy.isPhysicallyClient()) {
                    plugin.registerClient(WailaClientRegistration.instance());
                }
            }
            catch (Throwable plugin) {
                // empty catch block
            }
        }
        Set<Object> extraKeys = CommonProxy.isPhysicallyClient() ? WailaClientRegistration.instance().getConfigKeys() : Set.of();
        WailaCommonRegistration.instance().priorities.sort(extraKeys);
        WailaCommonRegistration.instance().loadComplete();
        if (CommonProxy.isPhysicallyClient()) {
            WailaClientRegistration.instance().loadComplete();
            Codec codec = WailaConfig.MAP_CODEC.codec();
            ImmutableList.Builder list = ImmutableList.builderWithExpectedSize((int)4);
            list.add(rootConfig);
            for (int i = 1; i < 4; ++i) {
                list.add(new JsonConfig<WailaConfig>("%s/profiles/%s/%s".formatted(ID, i, ID), codec, WailaConfig::fixData));
            }
            configs = list.build();
            Jade.rootConfig().history.checkNewUser(CommonProxy.getConfigDirectory().getAbsolutePath().hashCode());
            Jade.rootConfig().fixData();
            for (JsonConfig<? extends WailaConfig> config : configs) {
                config.save();
            }
            WailaConfig.init();
            JadeClient.refreshKeyState();
        }
    }

    public static List<JsonConfig<? extends WailaConfig>> configs() {
        return configs;
    }

    public static void useProfile(int index) {
        Jade.rootConfig().setEnableProfiles(true);
        Jade.rootConfig().profileIndex = index;
        rootConfig.save();
    }

    public static void saveProfile(int index) {
        JsonConfig<? extends WailaConfig> dest = Jade.configs().get(index);
        Jade.configHolder().saveTo(dest.getFile());
        dest.invalidate();
    }
}

