/*
 * Decompiled with CFR 0.152.
 */
package com.hamarb123.macos_input_fixes;

import com.hamarb123.macos_input_fixes.FabricReflectionHelper;
import com.hamarb123.macos_input_fixes.MacOSInputFixesClientMod;
import com.hamarb123.macos_input_fixes.OptionMixinHelper;
import com.hamarb123.macos_input_fixes.mixin.MinecraftClientAccessor;
import com.hamarb123.macos_input_fixes.mixin.gui.GameOptionsAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import org.apache.commons.io.IOUtils;

@Environment(value=EnvType.CLIENT)
public class ModOptions {
    private static boolean loadedInterface = false;
    public static File optionsFile;
    public static double trackpadSensitivity;
    public static Object TRACKPAD_SENSITIVITY;
    public static boolean reverseHotbarScrolling;
    public static Object REVERSE_HOTBAR_SCROLLING;
    public static boolean reverseScrolling;
    public static Object REVERSE_SCROLLING;
    public static boolean momentumScrolling;
    public static Object MOMENTUM_SCROLLING;
    public static boolean interfaceSmoothScroll;
    public static Object INTERFACE_SMOOTH_SCROLL;
    public static boolean disableCtrlClickFix;
    public static Object DISABLE_CTRL_CLICK_FIX;

    private static class_2561 createLiteralText(String value) {
        if (FabricReflectionHelper.Has_Text_literal()) {
            return FabricReflectionHelper.Text_literal(value);
        }
        return FabricReflectionHelper.new_LiteralText(value);
    }

    private static Object doubleOption(String key, String prefix, double min, double max, float step, Supplier<Double> getter, Consumer<Double> setter, String tooltip) {
        try {
            if (FabricReflectionHelper.Try_DoubleOption() != null) {
                BiFunction<class_315, Object, Object> displayStringGetter;
                Constructor<?> ctorM;
                boolean is117Plus = false;
                int version = 1160;
                if (tooltip == null || !FabricReflectionHelper.Has_new_DoubleOption_8()) {
                    ctorM = FabricReflectionHelper.Info_new_DoubleOption7();
                } else {
                    ctorM = FabricReflectionHelper.Info_new_DoubleOption8();
                    is117Plus = true;
                    version = 1170;
                }
                Function<class_315, Double> _getter = gameOptions -> (Double)getter.get();
                BiConsumer<class_315, Double> _setter = (gameOptions, value) -> {
                    setter.accept((Double)value);
                    ModOptions.saveOptions();
                };
                if (((ParameterizedType)ctorM.getGenericParameterTypes()[6]).getActualTypeArguments()[2] == String.class) {
                    displayStringGetter = (gameOptions, doubleOption) -> prefix + ": " + getter.get();
                    version = 1140;
                } else {
                    displayStringGetter = (gameOptions, doubleOption) -> ModOptions.createLiteralText(prefix + ": " + getter.get());
                }
                if (tooltip == null) {
                    return FabricReflectionHelper.new_DoubleOption(key, min, max, step, _getter, _setter, displayStringGetter);
                }
                Object tooltipObject = ModOptions.createTooltip(true, tooltip, version);
                if (is117Plus) {
                    return FabricReflectionHelper.new_DoubleOption(key, min, max, step, _getter, _setter, displayStringGetter, (Function)tooltipObject);
                }
                Object returnValue = FabricReflectionHelper.new_DoubleOption(key, min, max, step, _getter, _setter, displayStringGetter);
                returnValue = ModOptions.writeTooltip(returnValue, tooltipObject, version);
                return returnValue;
            }
            double step2 = (max - min) / (double)step;
            FabricReflectionHelper.ValueTextGetterHelper<Double> valueTextGetterImpl = (optionText, value) -> {
                double result = (double)((float)Math.round(value * step2) * step) + min;
                return ModOptions.createLiteralText(prefix + ": " + result);
            };
            Object valueTextGetter = FabricReflectionHelper.convertToSimpleOption_ValueTextGetter(valueTextGetterImpl);
            Double defaultValue = (getter.get() - min) / (max - min);
            Consumer<Double> changeCallback = value -> {
                double result = (double)((float)Math.round(value * step2) * step) + min;
                setter.accept(result);
                ModOptions.saveOptions();
            };
            if (FabricReflectionHelper.Try_SimpleOption_TooltipFactoryGetter() != null) {
                Object tooltipParameter = ModOptions.createTooltip(true, tooltip, 1190);
                return FabricReflectionHelper.new_SimpleOption_1(key, tooltipParameter, valueTextGetter, FabricReflectionHelper.SimpleOption_DoubleSliderCallbacks_INSTANCE(), defaultValue, changeCallback);
            }
            Object tooltipParameter = ModOptions.createTooltip(true, tooltip, 1193);
            return FabricReflectionHelper.new_SimpleOption_2(key, tooltipParameter, valueTextGetter, FabricReflectionHelper.SimpleOption_DoubleSliderCallbacks_INSTANCE(), defaultValue, changeCallback);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to create the double option interface element.", t);
        }
    }

    private static Object booleanOption(String key, String prefix, Supplier<Boolean> getter, Consumer<Boolean> setter, String tooltip) {
        try {
            Object returnValue;
            if (FabricReflectionHelper.Try_CyclingOption() != null) {
                BiFunction<class_315, Object, Object> displayStringGetter;
                if (FabricReflectionHelper.Try_CyclingOption_Setter() != null) {
                    Function<class_315, Boolean> _getter = gameOptions -> (Boolean)getter.get();
                    FabricReflectionHelper.CyclingOptionSetterHelper<Boolean> _setter = (gameOptions, option, value) -> {
                        setter.accept((Boolean)value);
                        ModOptions.saveOptions();
                    };
                    Object _setter2 = FabricReflectionHelper.convertToCyclingOption_Setter(_setter);
                    Object returnValue2 = FabricReflectionHelper.CyclingOption_create(key, ModOptions.createLiteralText(prefix + ": ON"), ModOptions.createLiteralText(prefix + ": OFF"), _getter, _setter2);
                    ((OptionMixinHelper)returnValue2).setOmitBuilderKeyText();
                    if (tooltip != null) {
                        Object tooltipObject = ModOptions.createTooltip(false, tooltip, 1170);
                        returnValue2 = ModOptions.writeTooltip(returnValue2, tooltipObject, 1170);
                    }
                    return returnValue2;
                }
                BiConsumer<class_315, Integer> _setter = (gameOptions, value) -> {
                    setter.accept((Boolean)getter.get() == false);
                    ModOptions.saveOptions();
                };
                int version = 1160;
                if (((ParameterizedType)FabricReflectionHelper.Info_new_CyclingOption3().getGenericParameterTypes()[2]).getActualTypeArguments()[2] == String.class) {
                    displayStringGetter = (gameOptions, booleanOption) -> prefix + ((Boolean)getter.get() != false ? ": ON" : ": OFF");
                    version = 1140;
                } else {
                    displayStringGetter = (gameOptions, booleanOption) -> ModOptions.createLiteralText(prefix + ((Boolean)getter.get() != false ? ": ON" : ": OFF"));
                }
                Object returnValue3 = FabricReflectionHelper.new_CyclingOption(key, _setter, displayStringGetter);
                if (tooltip != null) {
                    Object tooltipObject = ModOptions.createTooltip(false, tooltip, version);
                    returnValue3 = ModOptions.writeTooltip(returnValue3, tooltipObject, version);
                }
                return returnValue3;
            }
            FabricReflectionHelper.ValueTextGetterHelper<Boolean> valueTextGetterImpl = (optionText, value) -> ModOptions.createLiteralText(prefix + ": " + (value != false ? "ON" : "OFF"));
            Object valueTextGetter = FabricReflectionHelper.convertToSimpleOption_ValueTextGetter(valueTextGetterImpl);
            Consumer<Boolean> changeCallback = value -> {
                setter.accept((Boolean)value);
                ModOptions.saveOptions();
            };
            if (FabricReflectionHelper.Try_SimpleOption_TooltipFactoryGetter() != null) {
                Object tooltipParameter = ModOptions.createTooltip(false, tooltip, 1190);
                returnValue = FabricReflectionHelper.new_SimpleOption_1(key, tooltipParameter, valueTextGetter, FabricReflectionHelper.SimpleOption_BOOLEAN(), getter.get(), changeCallback);
            } else {
                Object tooltipParameter = ModOptions.createTooltip(false, tooltip, 1193);
                returnValue = FabricReflectionHelper.new_SimpleOption_2(key, tooltipParameter, valueTextGetter, FabricReflectionHelper.SimpleOption_BOOLEAN(), getter.get(), changeCallback);
            }
            ((OptionMixinHelper)returnValue).setOmitBuilderKeyText();
            return returnValue;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to create the boolean option interface element.", t);
        }
    }

    private static Object createTooltip(boolean isDouble, String tooltip, int version) throws Throwable {
        if (version >= 1193) {
            return tooltip == null ? FabricReflectionHelper.SimpleOption_emptyTooltip_2() : FabricReflectionHelper.SimpleOption_constantTooltip_2(ModOptions.createLiteralText(tooltip));
        }
        if (version >= 1190) {
            return tooltip == null ? FabricReflectionHelper.SimpleOption_emptyTooltip_1() : FabricReflectionHelper.SimpleOption_constantTooltip_1(ModOptions.createLiteralText(tooltip));
        }
        if (version >= 1170) {
            String[] strings;
            ArrayList<Object> tooltipList = new ArrayList<Object>();
            for (String str : strings = tooltip.split("\\n")) {
                for (String str2 : ModOptions.splitTooltipLine(str)) {
                    tooltipList.add(FabricReflectionHelper.OrderedText_styledForwardsVisitedString(str2, FabricReflectionHelper.Style_EMPTY()));
                }
            }
            Function<Object, Object> tooltipFunc = o -> tooltipList;
            if (isDouble) {
                return tooltipFunc;
            }
            Object tooltipFunc2 = FabricReflectionHelper.convertToCyclingButtonWidget_TooltipFactory(tooltipFunc);
            Function<class_310, Object> tooltips = client -> tooltipFunc2;
            return tooltips;
        }
        if (version >= 1160) {
            if (FabricReflectionHelper.Try_OrderedText() != null) {
                String[] strings = tooltip.split("\\n");
                ArrayList<Object> tooltipList = new ArrayList<Object>();
                for (String str : strings) {
                    for (String str2 : ModOptions.splitTooltipLine(str)) {
                        tooltipList.add(FabricReflectionHelper.OrderedText_styledForwardsVisitedString(str2, FabricReflectionHelper.Style_EMPTY()));
                    }
                }
                return tooltipList;
            }
            String[] strings = tooltip.split("\\n");
            ArrayList<Object> tooltipList = new ArrayList<Object>();
            for (String str : strings) {
                for (String str2 : ModOptions.splitTooltipLine(str)) {
                    tooltipList.add(FabricReflectionHelper.StringVisitable_styled(str2, FabricReflectionHelper.Style_EMPTY()));
                }
            }
            return tooltipList;
        }
        return null;
    }

    private static List<String> splitTooltipLine(String line) throws Throwable {
        List<?> listVisitable = FabricReflectionHelper.TextHandler_wrapLines(FabricReflectionHelper.TextRenderer_getTextHandler(((MinecraftClientAccessor)class_310.method_1551()).getTextRenderer()), line, 200, FabricReflectionHelper.Style_EMPTY());
        ArrayList<String> resultList = new ArrayList<String>();
        for (Object o : listVisitable) {
            resultList.add(FabricReflectionHelper.StringVisitable_getString(o));
        }
        return resultList;
    }

    private static Object writeTooltip(Object option, Object tooltipObject, int version) throws Throwable {
        if (version >= 1190) {
            throw new RuntimeException("writeTooltip is not implemented for 1.19+");
        }
        if (version >= 1170) {
            return FabricReflectionHelper.CyclingOption_tooltip(option, (Function)tooltipObject);
        }
        if (version >= 1160) {
            FabricReflectionHelper.Option_setTooltip(option, (List)tooltipObject);
            return option;
        }
        return option;
    }

    public static Object[] getModOptions() {
        ModOptions.loadInterface();
        if (class_310.field_1703) {
            Object[] arr = new Object[]{REVERSE_SCROLLING, REVERSE_HOTBAR_SCROLLING, TRACKPAD_SENSITIVITY, MOMENTUM_SCROLLING, INTERFACE_SMOOTH_SCROLL, DISABLE_CTRL_CLICK_FIX};
            return arr;
        }
        Object[] arr = new Object[]{REVERSE_SCROLLING, REVERSE_HOTBAR_SCROLLING};
        return arr;
    }

    private static void loadInterface() {
        if (loadedInterface) {
            return;
        }
        try {
            if (class_310.field_1703) {
                TRACKPAD_SENSITIVITY = ModOptions.doubleOption("options.macos_input_fixes.trackpad_sensitivity", "Trackpad Sensitivity", 0.0, 100.0, 1.0f, () -> trackpadSensitivity, value -> ModOptions.setTrackpadSensitivity(value), "The grouping feature only affects hotbar scrolling.\nThis feature only affects scrolling from the trackpad (and other high precision devices).\nDefault: 20.0\n0.0: Disable custom trackpad scroll processing.\nOther: group scrolls together to make scrolling speed much more reasonable on hotbar, scroll amount is divided by the value chosen here.");
                MOMENTUM_SCROLLING = ModOptions.booleanOption("options.macos_input_fixes.momentum_scrolling", "Momentum Scrolling", () -> momentumScrolling, value -> ModOptions.setMomentumScrolling(value), "Only affects hotbar scrolling.\nA momentum scroll is when macOS keeps scrolling after you release the wheel.\nDefault: OFF\nOFF: ignore 'momentum scroll' events.\nON: process 'momentum scroll' events.");
                INTERFACE_SMOOTH_SCROLL = ModOptions.booleanOption("options.macos_input_fixes.smooth_scroll", "Interface Smooth Scroll", () -> interfaceSmoothScroll, value -> ModOptions.setInterfaceSmoothScroll(value), "Affects all scrolling from legacy input devices (except for the hotbar).\nmacOS sometimes adjusts how much a single scroll does to make it feel 'smoother', but this can cause scroll amounts to feel random sometimes.\nDefault: OFF\nOFF: Modify smooth scrolling events to all be the same scroll amount.\nON: Keep smooth scrolling events as-is.");
                DISABLE_CTRL_CLICK_FIX = ModOptions.booleanOption("options.macos_input_fixes.disable_ctrl_click_fix", "Disable Ctrl+Click Fix", () -> disableCtrlClickFix, value -> {
                    disableCtrlClickFix = value;
                }, "When enabled, disables the fix for the bug which causes Minecraft\nto map Control + Left Click to Right Click.");
            }
            REVERSE_HOTBAR_SCROLLING = ModOptions.booleanOption("options.macos_input_fixes.reverse_hotbar_scrolling", "Reverse Hotbar Scroll", () -> reverseHotbarScrolling, value -> {
                reverseHotbarScrolling = value;
            }, "Reverses the direction that scrolling goes for the hotbar when enabled.");
            REVERSE_SCROLLING = ModOptions.booleanOption("options.macos_input_fixes.reverse_scrolling", "Reverse Scrolling", () -> reverseScrolling, value -> {
                reverseScrolling = value;
            }, "Reverses the direction of all scrolling when enabled.");
            loadedInterface = true;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialise option interface elements.", t);
        }
    }

    public static void loadOptions() {
        optionsFile = new File(class_310.method_1551().field_1697, "options_macos_input_fixes.txt");
        try {
            Boolean value;
            if (!optionsFile.exists()) {
                return;
            }
            List lines = IOUtils.readLines((InputStream)new FileInputStream(optionsFile), (Charset)StandardCharsets.UTF_8);
            class_2487 compoundTag = new class_2487();
            for (String line : lines) {
                try {
                    Iterator iterator = GameOptionsAccessor.COLON_SPLITTER().omitEmptyStrings().limit(2).split((CharSequence)line).iterator();
                    compoundTag.method_10582((String)iterator.next(), (String)iterator.next());
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
            }
            if (compoundTag.method_10545("trackpadSensitivity")) {
                double actualValue = 20.0;
                try {
                    Double value2 = Double.parseDouble(compoundTag.method_10558("trackpadSensitivity"));
                    actualValue = value2;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
                ModOptions.setTrackpadSensitivity(actualValue);
            }
            if (compoundTag.method_10545("reverseHotbarScrolling")) {
                boolean actualValue = false;
                try {
                    value = Boolean.parseBoolean(compoundTag.method_10558("reverseHotbarScrolling"));
                    actualValue = value;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
                reverseHotbarScrolling = actualValue;
            }
            if (compoundTag.method_10545("reverseScrolling")) {
                boolean actualValue = false;
                try {
                    value = Boolean.parseBoolean(compoundTag.method_10558("reverseScrolling"));
                    actualValue = value;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
                reverseScrolling = actualValue;
            }
            if (compoundTag.method_10545("momentumScrolling")) {
                boolean actualValue = false;
                try {
                    value = Boolean.parseBoolean(compoundTag.method_10558("momentumScrolling"));
                    actualValue = value;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
                ModOptions.setMomentumScrolling(actualValue);
            }
            if (compoundTag.method_10545("interfaceSmoothScroll")) {
                boolean actualValue = false;
                try {
                    value = Boolean.parseBoolean(compoundTag.method_10558("interfaceSmoothScroll"));
                    actualValue = value;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
                ModOptions.setInterfaceSmoothScroll(actualValue);
            }
            if (compoundTag.method_10545("disableCtrlClickFix")) {
                boolean actualValue = false;
                try {
                    value = Boolean.parseBoolean(compoundTag.method_10558("disableCtrlClickFix"));
                    actualValue = value;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace(System.err);
                }
                disableCtrlClickFix = actualValue;
            }
            loadedInterface = false;
        }
        catch (Exception ex2) {
            ex2.printStackTrace(System.err);
        }
    }

    public static void saveOptions() {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(optionsFile), StandardCharsets.UTF_8));){
            printWriter.println("trackpadSensitivity:" + trackpadSensitivity);
            printWriter.println("reverseHotbarScrolling:" + reverseHotbarScrolling);
            printWriter.println("reverseScrolling:" + reverseScrolling);
            printWriter.println("momentumScrolling:" + momentumScrolling);
            printWriter.println("interfaceSmoothScroll:" + interfaceSmoothScroll);
            printWriter.println("disableCtrlClickFix:" + disableCtrlClickFix);
        }
        catch (Exception ex2) {
            ex2.printStackTrace(System.err);
        }
    }

    public static void setTrackpadSensitivity(double value) {
        trackpadSensitivity = value;
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 100.0) {
            value = 100.0;
        }
        MacOSInputFixesClientMod.setTrackpadSensitivity(value);
    }

    public static void setMomentumScrolling(boolean value) {
        momentumScrolling = value;
        MacOSInputFixesClientMod.setMomentumScrolling(value);
    }

    public static void setInterfaceSmoothScroll(boolean value) {
        interfaceSmoothScroll = value;
        MacOSInputFixesClientMod.setInterfaceSmoothScroll(value);
    }

    static {
        trackpadSensitivity = 20.0;
        reverseHotbarScrolling = false;
        reverseScrolling = false;
        momentumScrolling = false;
        interfaceSmoothScroll = false;
        disableCtrlClickFix = false;
    }
}

