/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.transformation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.math.vec.Vec3f;
import team.creative.creativecore.common.util.math.vec.VectorUtils;

public enum Rotation {
    X_CLOCKWISE(Axis.X, new IntMatrix3(1, 0, 0, 0, 0, -1, 0, 1, 0), true){

        @Override
        public Rotation opposite() {
            return X_COUNTER_CLOCKWISE;
        }
    }
    ,
    X_COUNTER_CLOCKWISE(Axis.X, new IntMatrix3(1, 0, 0, 0, 0, 1, 0, -1, 0), false){

        @Override
        public Rotation opposite() {
            return X_CLOCKWISE;
        }
    }
    ,
    Y_CLOCKWISE(Axis.Y, new IntMatrix3(0, 0, 1, 0, 1, 0, -1, 0, 0), true){

        @Override
        public Rotation opposite() {
            return Y_COUNTER_CLOCKWISE;
        }
    }
    ,
    Y_COUNTER_CLOCKWISE(Axis.Y, new IntMatrix3(0, 0, -1, 0, 1, 0, 1, 0, 0), false){

        @Override
        public Rotation opposite() {
            return Y_CLOCKWISE;
        }
    }
    ,
    Z_CLOCKWISE(Axis.Z, new IntMatrix3(0, -1, 0, 1, 0, 0, 0, 0, 1), true){

        @Override
        public Rotation opposite() {
            return Z_COUNTER_CLOCKWISE;
        }
    }
    ,
    Z_COUNTER_CLOCKWISE(Axis.Z, new IntMatrix3(0, 1, 0, -1, 0, 0, 0, 0, 1), false){

        @Override
        public Rotation opposite() {
            return Z_CLOCKWISE;
        }
    };

    private static final Facing[][] FACING_ROTATION;
    public final Axis axis;
    public final int direction;
    public final boolean clockwise;
    private final Vec3i normal;
    private final IntMatrix3c rotMatrix;

    public static Rotation getRotation(Axis axis, boolean clockwise) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> {
                if (clockwise) {
                    yield X_CLOCKWISE;
                }
                yield X_COUNTER_CLOCKWISE;
            }
            case Axis.Y -> {
                if (clockwise) {
                    yield Y_CLOCKWISE;
                }
                yield Y_COUNTER_CLOCKWISE;
            }
            case Axis.Z -> clockwise ? Z_CLOCKWISE : Z_COUNTER_CLOCKWISE;
        };
    }

    public static Rotation ofNormal(Vec3i vec) {
        if (vec.getX() > 0) {
            return X_CLOCKWISE;
        }
        if (vec.getX() < 0) {
            return X_COUNTER_CLOCKWISE;
        }
        if (vec.getY() > 0) {
            return Y_CLOCKWISE;
        }
        if (vec.getY() < 0) {
            return Y_COUNTER_CLOCKWISE;
        }
        if (vec.getZ() > 0) {
            return Z_CLOCKWISE;
        }
        if (vec.getZ() < 0) {
            return Z_COUNTER_CLOCKWISE;
        }
        return null;
    }

    public static Rotation getRotation(net.minecraft.world.level.block.Rotation rotationIn) {
        return switch (rotationIn) {
            case net.minecraft.world.level.block.Rotation.CLOCKWISE_90 -> Y_CLOCKWISE;
            case net.minecraft.world.level.block.Rotation.CLOCKWISE_180 -> Y_CLOCKWISE;
            case net.minecraft.world.level.block.Rotation.COUNTERCLOCKWISE_90 -> Y_COUNTER_CLOCKWISE;
            default -> null;
        };
    }

    public static int getRotationCount(net.minecraft.world.level.block.Rotation rotationIn) {
        if (rotationIn == net.minecraft.world.level.block.Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 1;
    }

    private Rotation(Axis axis, IntMatrix3c matrix, boolean clockwise) {
        this.rotMatrix = matrix;
        this.axis = axis;
        this.clockwise = clockwise;
        this.direction = clockwise ? 1 : -1;
        this.normal = VectorUtils.set(Vec3i.ZERO, this.direction, axis);
    }

    public IntMatrix3c getMatrix() {
        return this.rotMatrix;
    }

    public abstract Rotation opposite();

    public Facing rotate(Facing facing) {
        return FACING_ROTATION[facing.ordinal()][this.ordinal()];
    }

    public Axis rotate(Axis axis) {
        if (axis == this.axis) {
            return axis;
        }
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Axis.X -> {
                if (this.axis == Axis.Y) {
                    yield Axis.Z;
                }
                yield Axis.Y;
            }
            case Axis.Y -> {
                if (this.axis == Axis.Z) {
                    yield Axis.X;
                }
                yield Axis.Y;
            }
            case Axis.Z -> this.axis == Axis.X ? Axis.Y : Axis.X;
        };
    }

    public Rotation mirror(Axis axis) {
        return this.axis == axis ? this.opposite() : this;
    }

    public Rotation rotate(Rotation by) {
        return Rotation.ofNormal(by.getMatrix().transform(this.normal));
    }

    public Rotation transform(IntMatrix3c matrix) {
        return Rotation.ofNormal(matrix.transform(this.normal));
    }

    public BlockPos transform(BlockPos vec) {
        return this.rotMatrix.transform(vec);
    }

    public Vec3i transform(Vec3i vec) {
        return this.rotMatrix.transform(vec);
    }

    public Vec3 transform(Vec3 vec) {
        return this.rotMatrix.transform(vec);
    }

    public void transform(Vec3d vec) {
        this.rotMatrix.transform(vec);
    }

    public void transform(Vec3f vec) {
        this.rotMatrix.transform(vec);
    }

    static {
        FACING_ROTATION = new Facing[6][6];
        for (int i = 0; i < FACING_ROTATION.length; ++i) {
            Facing facing = Facing.get(i);
            block1: for (int j = 0; j < Rotation.values().length; ++j) {
                Rotation rotation = Rotation.values()[j];
                Vec3i rotatedNormal = new Vec3i(rotation.getMatrix().getX(facing.normal), rotation.getMatrix().getY(facing.normal), rotation.getMatrix().getZ(facing.normal));
                for (int k = 0; k < Facing.values().length; ++k) {
                    if (!Facing.get((int)k).normal.equals((Object)rotatedNormal)) continue;
                    Rotation.FACING_ROTATION[i][j] = Facing.get(k);
                    continue block1;
                }
            }
        }
    }
}

