/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import java.util.Stack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public interface Shieldable
extends Ability {
    public ShieldPosition getShieldPosition(int var1);

    public byte getMaxShieldsPerSide();

    default public void tickShieldShip() {
    }

    default public void defineShieldShipSynchedData(SynchedEntityData.Builder builder) {
        builder.define(Ship.SHIELD_DATA, (Object)new CompoundTag());
    }

    default public void readShieldShipSaveData(CompoundTag tag) {
        ListTag shieldItems = tag.getList("Shields", 10);
        for (int i = 0; i < shieldItems.size(); ++i) {
            CompoundTag compoundTag = shieldItems.getCompound(i);
            ItemStack itemStack = ItemStack.parse((HolderLookup.Provider)this.self().registryAccess(), (Tag)compoundTag).orElse(ItemStack.EMPTY);
            if (itemStack.isEmpty()) continue;
            this.self().SHIELDS.push(itemStack);
        }
        this.self().setShieldData(tag);
    }

    default public void addShieldShipSaveData(CompoundTag tag) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.self().SHIELDS.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.self().SHIELDS.get(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag inTag = new CompoundTag();
            inTag.putByte("Shields", (byte)i);
            Tag itemTag = itemstack.save((HolderLookup.Provider)this.self().registryAccess(), (Tag)inTag);
            listTag.add((Object)itemTag);
        }
        tag.put("Shields", (Tag)listTag);
        this.self().setShieldData(tag);
    }

    default public Stack<ItemStack> getShields() {
        if (this.self().SHIELDS.isEmpty() && !this.self().getShieldData().isEmpty() && this.self().getCommandSenderWorld().isClientSide()) {
            this.readShieldShipSaveData(this.self().getShieldData());
        }
        return this.self().SHIELDS;
    }

    default public float getDamageModifier() {
        return (float)(1.0 - (double)this.getShields().size() * (Double)SmallShipsConfig.Common.shipGeneralShieldDamageReduction.get() / 100.0);
    }

    default public boolean interactShield(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        int shieldCount = this.getShields().size();
        if (itemStack.is(Items.SHIELD)) {
            if (shieldCount >= this.getMaxShieldsPerSide() * 2) {
                return false;
            }
            this.getShields().push(itemStack.copy());
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            this.self().getCommandSenderWorld().playSound(player, this.self().getX(), this.self().getY() + 4.0, this.self().getZ(), SoundEvents.WOOD_HIT, this.self().getSoundSource(), 15.0f, 1.5f);
            return true;
        }
        if (itemStack.getItem() instanceof AxeItem && shieldCount > 0) {
            ItemStack removedShield = this.getShields().pop();
            this.self().spawnAtLocation(removedShield, 2.0f);
            this.self().getCommandSenderWorld().playSound(player, this.self().getX(), this.self().getY() + 4.0, this.self().getZ(), SoundEvents.WOOD_HIT, this.self().getSoundSource(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static class ShieldPosition {
        public final double x;
        public final double y;
        public final double z;
        public final boolean isRightSided;

        public ShieldPosition(double x, double y, double z, boolean isRightSided) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.isRightSided = isRightSided;
        }
    }
}

