/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.neoforge;

import com.talhanation.smallships.world.entity.cannon.GroundCannonEntity;
import com.talhanation.smallships.world.entity.projectile.CannonBallEntity;
import com.talhanation.smallships.world.entity.ship.BriggEntity;
import com.talhanation.smallships.world.entity.ship.CogEntity;
import com.talhanation.smallships.world.entity.ship.DrakkarEntity;
import com.talhanation.smallships.world.entity.ship.GalleyEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntityTypesImpl {
    private static final Map<Class<? extends Entity>, DeferredHolder<EntityType<? extends Entity>, EntityType<? extends Entity>>> entries = new HashMap<Class<? extends Entity>, DeferredHolder<EntityType<? extends Entity>, EntityType<? extends Entity>>>();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"smallships");

    public static <T extends Entity> EntityType<T> getEntityType(Class<T> entityClass) {
        return (EntityType)entries.get(entityClass).get();
    }

    private static DeferredHolder<EntityType<?>, EntityType<?>> register(String id, EntityType.Builder<?> builder) {
        return ENTITY_TYPES.register(id, () -> builder.build(ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)id).toString()));
    }

    static {
        entries.put(CannonBallEntity.class, ModEntityTypesImpl.register("cannon_ball", EntityType.Builder.of(CannonBallEntity::factory, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(20).updateInterval(10)));
        entries.put(GroundCannonEntity.class, ModEntityTypesImpl.register("ground_cannon", EntityType.Builder.of(GroundCannonEntity::factory, (MobCategory)MobCategory.MISC).sized(0.85f, 0.75f).clientTrackingRange(20).updateInterval(10)));
        entries.put(CogEntity.class, ModEntityTypesImpl.register("cog", EntityType.Builder.of(CogEntity::new, (MobCategory)MobCategory.MISC).sized(3.5f, 1.25f).clientTrackingRange(20).updateInterval(10)));
        entries.put(BriggEntity.class, ModEntityTypesImpl.register("brigg", EntityType.Builder.of(BriggEntity::new, (MobCategory)MobCategory.MISC).sized(3.5f, 1.25f).clientTrackingRange(20).updateInterval(10)));
        entries.put(GalleyEntity.class, ModEntityTypesImpl.register("galley", EntityType.Builder.of(GalleyEntity::new, (MobCategory)MobCategory.MISC).sized(3.5f, 1.25f).clientTrackingRange(20).updateInterval(10)));
        entries.put(DrakkarEntity.class, ModEntityTypesImpl.register("drakkar", EntityType.Builder.of(DrakkarEntity::new, (MobCategory)MobCategory.MISC).sized(3.5f, 1.25f).clientTrackingRange(20).updateInterval(10)));
    }
}

