/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.cannon;

import com.talhanation.smallships.network.ModPackets;
import com.talhanation.smallships.network.packet.ServerboundEnterCannonBarrelPacket;
import com.talhanation.smallships.network.packet.ServerboundShootGroundCannonPacket;
import com.talhanation.smallships.world.entity.IMixinEntity;
import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.cannon.Cannon;
import com.talhanation.smallships.world.entity.cannon.ICannon;
import com.talhanation.smallships.world.entity.cannon.ICannonBallSource;
import com.talhanation.smallships.world.entity.projectile.CannonBallEntity;
import com.talhanation.smallships.world.entity.projectile.ICannonProjectile;
import com.talhanation.smallships.world.item.CannonBallItem;
import com.talhanation.smallships.world.item.ModItems;
import com.talhanation.smallships.world.particles.ModParticleTypes;
import com.talhanation.smallships.world.particles.cannon.DyedCannonShootOptions;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class GroundCannonEntity
extends Minecart
implements ICannon {
    public static final String ID = "ground_cannon";
    private static final EntityDataAccessor<Optional<UUID>> UUID = SynchedEntityData.defineId(GroundCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> DYE = SynchedEntityData.defineId(GroundCannonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final Cannon cannon = new Cannon(this);
    private boolean drivenPrevTick = false;

    public GroundCannonEntity(Level level, Vec3 pos) {
        super(ModEntityTypes.GROUND_CANNON, level);
        this.setPos(pos);
    }

    public GroundCannonEntity(EntityType<? extends GroundCannonEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(UUID, Optional.empty());
        builder.define(DYE, (Object)"");
    }

    public Optional<UUID> getEntityInBarrelUUID() {
        return (Optional)this.entityData.get(UUID);
    }

    protected final void setEntityInBarrelUUID(UUID uuid) {
        this.entityData.set(UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public DyeColor getDye() {
        String dye = (String)this.entityData.get(DYE);
        return dye.isEmpty() ? null : DyeColor.byName((String)((String)this.entityData.get(DYE)), null);
    }

    @Nullable
    protected final void setDye(@Nullable DyeColor dye) {
        this.entityData.set(DYE, (Object)(dye != null ? dye.getSerializedName() : ""));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        DyeColor dye = this.getDye();
        if (dye != null) {
            tag.putString("Dye", dye.getSerializedName());
        }
        this.getEntityInBarrelUUID().ifPresent(uuid -> tag.putUUID("EntityInBarrelUUID", uuid));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Dye")) {
            this.setDye(DyeColor.byName((String)tag.getString("Dye"), null));
        }
        if (tag.contains("EntityInBarrelUUID")) {
            this.setEntityInBarrelUUID(tag.getUUID("EntityInBarrelUUID"));
        }
    }

    public Cannon getCannon() {
        return this.cannon;
    }

    public void tick() {
        boolean enteredCannon;
        float xRot = this.getXRot();
        float yRot = this.getYRot();
        super.tick();
        boolean isDriven = this.getPassengerDriver() != null;
        Entity driver = this.getPassengerDriver();
        boolean bl = enteredCannon = !this.drivenPrevTick && isDriven;
        if (enteredCannon) {
            this.getPassengerDriver().setYRot(this.getYRot());
            this.getPassengerDriver().setXRot(this.getXRot());
        }
        this.drivenPrevTick = isDriven;
        if (isDriven) {
            xRot = driver.getXRot();
            yRot = driver.getYRot();
        }
        xRot = Math.clamp(xRot, -90.0f, 20.0f);
        this.setYRot(yRot);
        this.setXRot(xRot);
        this.cannon.tick(this.getX(), this.getY(), this.getZ(), -yRot, xRot);
        this.testEntityIntersection();
    }

    protected void testEntityIntersection() {
        if (this.level().isClientSide()) {
            return;
        }
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, 0.0, (double)0.2f), EntitySelector.pushableBy((Entity)this));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                boolean isBarrelEmpty;
                boolean isEntityTypeAllowed = !(entity instanceof Player) && !(entity instanceof IronGolem) && !(entity instanceof AbstractMinecart);
                boolean bl = isBarrelEmpty = this.getPassengerInBarrel() == null;
                if (!isEntityTypeAllowed || !isBarrelEmpty || entity.isPassenger()) continue;
                this.tryPuttingIntoBarrel(entity);
            }
        }
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        if (this.itemInteraction(player, interactionHand)) {
            return InteractionResult.CONSUME;
        }
        if (player.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (this.getPassengers().size() == 2) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide()) {
            return this.tryRiding((Entity)player) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean itemInteraction(Player player, InteractionHand interactionHand) {
        if (!this.level().isClientSide() && interactionHand == InteractionHand.MAIN_HAND) {
            ItemStack item = player.getMainHandItem();
            Item item2 = item.getItem();
            if (item2 instanceof DyeItem) {
                DyeItem dye = (DyeItem)item2;
                if (!dye.getDyeColor().equals((Object)this.getDye())) {
                    item.shrink(1);
                    this.setDye(dye.getDyeColor());
                }
                return true;
            }
            if (item.is(Items.FLINT_AND_STEEL)) {
                this.setDye(null);
                return true;
            }
        }
        return false;
    }

    protected boolean tryRiding(Entity entity) {
        if (this.level().isClientSide()) {
            return false;
        }
        if (this.getPassengerInBarrel() == null && !this.getPassengers().isEmpty() && this.canAddPassenger(entity)) {
            return this.tryPuttingIntoBarrel(entity);
        }
        this.cleanEntityInBarrelUUID();
        return entity.startRiding((Entity)this);
    }

    protected boolean tryPuttingIntoBarrel(Entity entity) {
        if (this.level().isClientSide() || entity == null || this.getCannon().isFuzing()) {
            return false;
        }
        Entity barrelEntity = this.getPassengerInBarrel();
        if (barrelEntity == entity) {
            return true;
        }
        if (this.getPassengers().size() == 2) {
            return false;
        }
        if (barrelEntity != null) {
            return false;
        }
        if (!this.getPassengers().contains(entity)) {
            if (entity.startRiding((Entity)this)) {
                this.setEntityInBarrelUUID(entity.getUUID());
                return true;
            }
        } else {
            this.setEntityInBarrelUUID(entity.getUUID());
            return true;
        }
        return false;
    }

    public void putEntityIntoBarrel(Entity entity) {
        if (this.level().isClientSide()) {
            ModPackets.clientSendPacket(new ServerboundEnterCannonBarrelPacket(this.getId(), entity.getId()));
            return;
        }
        this.tryPuttingIntoBarrel(entity);
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() < 2;
    }

    public void trigger(Entity triggeredBy) {
        boolean canFuze;
        if (this.level().isClientSide()) {
            ModPackets.clientSendPacket(new ServerboundShootGroundCannonPacket(false));
            return;
        }
        CannonBallItem cannonBallToShoot = this.getPassengerInBarrel() == null ? this.getCannonBallToShoot() : null;
        boolean bl = canFuze = cannonBallToShoot != null || this.getPassengerInBarrel() != null;
        if (canFuze) {
            if (cannonBallToShoot != null) {
                this.consumeCannonBall();
            }
            this.cannon.triggerFuze(triggeredBy, () -> {
                if (cannonBallToShoot != null) {
                    return new CannonBallEntity(this.level());
                }
                return (ICannonProjectile)this.getPassengerInBarrel();
            });
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        if (this.getPassengerInBarrel() == entity) {
            Vector3d endPoint = this.cannon.getBarrelEndPointLocal();
            return new Vec3(endPoint.x, endPoint.y, endPoint.z);
        }
        return this.getBarrelPassengerAttachmentPoint();
    }

    protected Vec3 getBarrelPassengerAttachmentPoint() {
        Vector3f relativePoint = new Vector3f(0.0f, 0.0f, -0.5f).rotateAxis(-((float)Math.toRadians(this.getYRot())), 0.0f, 1.0f, 0.0f);
        return new Vec3((double)relativePoint.x, (double)relativePoint.y, (double)relativePoint.z);
    }

    public void onPassengerTurned(Entity entity) {
        super.onPassengerTurned(entity);
        if (this.getPassengerDriver() != entity) {
            return;
        }
        float prevXRot = ((IMixinEntity)entity).getPrevXRot();
        float prevYRot = ((IMixinEntity)entity).getPrevYRot();
        float yRotChange = Math.clamp(0.1f * (entity.getYRot() - prevYRot), -5.0f, 5.0f);
        float xRotChange = Math.clamp(0.1f * (entity.getXRot() - prevXRot), -5.0f, 5.0f);
        entity.setYRot(prevYRot + yRotChange);
        entity.setYBodyRot(prevYRot + yRotChange);
        entity.xRotO = prevXRot + xRotChange;
        entity.setXRot(Math.clamp(prevXRot + xRotChange, -90.0f, 20.0f));
    }

    public void destroy(Item arg) {
        this.kill();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemStack = new ItemStack((ItemLike)arg);
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            CompoundTag tag = new CompoundTag();
            this.addAdditionalSaveData(tag);
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.spawnAtLocation(itemStack);
        }
    }

    public Item getDropItem() {
        return ModItems.CANNON;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.CANNON);
    }

    public boolean isPushable() {
        return this.level().getBlockState(this.blockPosition()).is(BlockTags.RAILS);
    }

    @Nullable
    public Entity getPassengerDriver() {
        for (Entity passenger : this.getPassengers()) {
            if (passenger == this.getPassengerInBarrel()) continue;
            return passenger;
        }
        return null;
    }

    @Nullable
    public Entity getPassengerInBarrel() {
        Optional<UUID> uuid = this.getEntityInBarrelUUID();
        if (uuid.isEmpty()) {
            return null;
        }
        if (this.getPassengers().isEmpty()) {
            return null;
        }
        for (Entity passenger : this.getPassengers()) {
            if (!passenger.getUUID().equals(uuid.get())) continue;
            return passenger;
        }
        return null;
    }

    protected void cleanEntityInBarrelUUID() {
        if (this.getPassengers().isEmpty() || this.getPassengerInBarrel() == null) {
            this.setEntityInBarrelUUID(null);
        }
    }

    public static GroundCannonEntity factory(EntityType<? extends GroundCannonEntity> entityType, Level level) {
        return new GroundCannonEntity(entityType, level);
    }

    @Override
    public void consumeCannonBall() {
        LivingEntity livingDriver;
        Entity driver = this.getPassengerDriver();
        if (driver == null || driver instanceof LivingEntity && (livingDriver = (LivingEntity)driver).hasInfiniteMaterials()) {
            return;
        }
        if (driver instanceof ICannonBallSource) {
            ICannonBallSource container = (ICannonBallSource)driver;
            container.consumeCannonBall();
        } else {
            Entity entity = this.getPassengerDriver();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                for (ItemStack itemstack : player.getInventory().items) {
                    if (!itemstack.is((Item)ModItems.CANNON_BALL)) continue;
                    itemstack.shrink(1);
                    break;
                }
            }
        }
    }

    @Override
    public ParticleOptions provideShootParticles() {
        if (this.getDye() != null) {
            return new DyedCannonShootOptions(this.getDye());
        }
        return (ParticleOptions)ModParticleTypes.CANNON_SHOOT.get();
    }

    @Override
    public void playSoundAt(SoundEvent soundEvent, float volumeMultiplier, float pitch) {
        this.playSound(soundEvent, volumeMultiplier, pitch);
    }

    @Override
    public Level getLevel() {
        return this.level();
    }

    @Override
    public CannonBallItem getCannonBallToShoot() {
        if (this.getPassengerDriver() == null) {
            return null;
        }
        Entity entity = this.getPassengerDriver();
        if (entity instanceof ICannonBallSource) {
            ICannonBallSource container = (ICannonBallSource)entity;
            return container.getCannonBallToShoot();
        }
        entity = this.getPassengerDriver();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getInventory().items.stream().anyMatch(itemStack -> itemStack.getItem().equals((Object)ModItems.CANNON_BALL)) ? ModItems.CANNON_BALL : null;
        }
        return null;
    }
}

