/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.RecipeProvider;

import com.mrh0.createaddition.datagen.RecipeBuilders.ChargingRecipeBuilder;
import com.mrh0.createaddition.index.CARecipes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.block.CopperBlockSet;
import com.simibubi.create.foundation.data.recipe.ProcessingRecipeGen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import org.jetbrains.annotations.NotNull;

public class CAChargingRecipeProvider
extends ProcessingRecipeGen {
    public static final IRecipeTypeInfo recipeType = new IRecipeTypeInfo(){

        public ResourceLocation getId() {
            return CARecipes.CHARGING.getId();
        }

        public <T extends RecipeSerializer<?>> T getSerializer() {
            return (T)((RecipeSerializer)CARecipes.CHARGING.get());
        }

        public <V extends RecipeInput, R extends Recipe<V>> RecipeType<R> getType() {
            return CARecipes.CHARGING_TYPE.get();
        }
    };
    private final HolderLookup.Provider provider;

    public CAChargingRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        try {
            this.provider = registries.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void buildCreateDeoxidizeVariants(CopperBlockSet.Variant<?> variant, @NotNull RecipeOutput output) {
        ChargingRecipeBuilder.deoxidize((Block)AllBlocks.COPPER_SHINGLES.get(variant, WeatheringCopper.WeatherState.OXIDIZED, false).get(), (Block)AllBlocks.COPPER_SHINGLES.get(variant, WeatheringCopper.WeatherState.WEATHERED, false).get()).save(output);
        ChargingRecipeBuilder.deoxidize((Block)AllBlocks.COPPER_SHINGLES.get(variant, WeatheringCopper.WeatherState.WEATHERED, false).get(), (Block)AllBlocks.COPPER_SHINGLES.get(variant, WeatheringCopper.WeatherState.EXPOSED, false).get()).save(output);
        ChargingRecipeBuilder.deoxidize((Block)AllBlocks.COPPER_SHINGLES.get(variant, WeatheringCopper.WeatherState.EXPOSED, false).get(), (Block)AllBlocks.COPPER_SHINGLES.get(variant, WeatheringCopper.WeatherState.UNAFFECTED, false).get()).save(output);
        ChargingRecipeBuilder.deoxidize((Block)AllBlocks.COPPER_TILES.get(variant, WeatheringCopper.WeatherState.OXIDIZED, false).get(), (Block)AllBlocks.COPPER_TILES.get(variant, WeatheringCopper.WeatherState.WEATHERED, false).get()).save(output);
        ChargingRecipeBuilder.deoxidize((Block)AllBlocks.COPPER_TILES.get(variant, WeatheringCopper.WeatherState.WEATHERED, false).get(), (Block)AllBlocks.COPPER_TILES.get(variant, WeatheringCopper.WeatherState.EXPOSED, false).get()).save(output);
        ChargingRecipeBuilder.deoxidize((Block)AllBlocks.COPPER_TILES.get(variant, WeatheringCopper.WeatherState.EXPOSED, false).get(), (Block)AllBlocks.COPPER_TILES.get(variant, WeatheringCopper.WeatherState.UNAFFECTED, false).get()).save(output);
    }

    protected void buildRecipes(@NotNull RecipeOutput output) {
        ChargingRecipeBuilder.charging(new ItemStack((ItemLike)Items.ENCHANTED_BOOK), (ResourceKey<Enchantment>)Enchantments.CHANNELING, this.provider).require((ItemLike)Items.BOOK).maxChargeRate(1000).energy(10000000).save(output, ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)Enchantments.CHANNELING.location().getPath()));
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_CHISELED_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_COPPER_BULB).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_COPPER_DOOR).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_COPPER_GRATE).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_COPPER_TRAPDOOR).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_CUT_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_CUT_COPPER_SLAB).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.OXIDIZED_CUT_COPPER_STAIRS).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_CHISELED_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_COPPER_BULB).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_COPPER_DOOR).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_COPPER_GRATE).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_COPPER_TRAPDOOR).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_CUT_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_CUT_COPPER_SLAB).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.WEATHERED_CUT_COPPER_STAIRS).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_CHISELED_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_COPPER_BULB).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_COPPER_DOOR).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_COPPER_GRATE).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_COPPER_TRAPDOOR).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_CUT_COPPER).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_CUT_COPPER_SLAB).save(output);
        ChargingRecipeBuilder.deoxidize(Blocks.EXPOSED_CUT_COPPER_STAIRS).save(output);
        this.buildCreateDeoxidizeVariants((CopperBlockSet.Variant<?>)CopperBlockSet.SlabVariant.INSTANCE, output);
        this.buildCreateDeoxidizeVariants((CopperBlockSet.Variant<?>)CopperBlockSet.BlockVariant.INSTANCE, output);
        this.buildCreateDeoxidizeVariants((CopperBlockSet.Variant<?>)CopperBlockSet.StairVariant.INSTANCE, output);
    }

    protected IRecipeTypeInfo getRecipeType() {
        return recipeType;
    }
}

