/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.connector;

import com.mrh0.createaddition.blocks.connector.SmallLightConnectorBlockEntity;
import com.mrh0.createaddition.blocks.connector.base.AbstractConnectorBlock;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.index.CABlockEntities;
import com.mrh0.createaddition.shapes.CAShapes;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SmallLightConnectorBlock
extends AbstractConnectorBlock<SmallLightConnectorBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShaper CONNECTOR_SHAPE = CAShapes.shape(6.0, 0.0, 6.0, 10.0, 5.0, 10.0).add(5.0, 4.0, 5.0, 11.0, 10.0, 11.0).forDirectional();

    public SmallLightConnectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext c) {
        return (BlockState)super.getStateForPlacement(c).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODE, NodeRotation.ROTATION, VARIANT, POWERED});
    }

    public Class<SmallLightConnectorBlockEntity> getBlockEntityClass() {
        return SmallLightConnectorBlockEntity.class;
    }

    public BlockEntityType<? extends SmallLightConnectorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CABlockEntities.SMALL_LIGHT_CONNECTOR.get();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CABlockEntities.SMALL_LIGHT_CONNECTOR.create(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return CONNECTOR_SHAPE.get(((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }
}

