/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.net;

import de.maxhenkel.car.corelib.net.Message;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class MessageCenterCarClient
implements Message<MessageCenterCarClient> {
    public static final CustomPacketPayload.Type<MessageCenterCarClient> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"center_car_client"));
    private UUID uuid;

    public MessageCenterCarClient() {
    }

    public MessageCenterCarClient(Player player) {
        this.uuid = player.getUUID();
    }

    public MessageCenterCarClient(UUID uuid) {
        this.uuid = uuid;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void centerClient() {
        LocalPlayer player = Minecraft.getInstance().player;
        Player ridingPlayer = player.level().getPlayerByUUID(this.uuid);
        Entity entity = ridingPlayer.getVehicle();
        if (!(entity instanceof EntityCarBase)) {
            return;
        }
        EntityCarBase car = (EntityCarBase)entity;
        if (ridingPlayer.equals((Object)car.getDriver())) {
            car.centerCar();
        }
    }

    @Override
    public PacketFlow getExecutingSide() {
        return PacketFlow.CLIENTBOUND;
    }

    @Override
    public void executeClientSide(IPayloadContext context) {
        this.centerClient();
    }

    @Override
    public MessageCenterCarClient fromBytes(RegistryFriendlyByteBuf buf) {
        this.uuid = buf.readUUID();
        return this;
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.uuid);
    }

    @Override
    public CustomPacketPayload.Type<MessageCenterCarClient> type() {
        return TYPE;
    }
}

