/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.blocks.BlockPaint;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.SlotPainter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemPainter
extends Item {
    private final boolean isYellow;

    public ItemPainter(boolean isYellow) {
        super(new Item.Properties().stacksTo(1).durability(1024));
        this.isYellow = isYellow;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.getBlock() instanceof BlockPaint) {
            return 50.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, final Player playerIn, final InteractionHand handIn) {
        if (playerIn.isShiftKeyDown() && playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return ItemPainter.this.getName(playerIn.getItemInHand(handIn));
                }

                @Nullable
                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new ContainerPainter(i, playerInventory, ItemPainter.this.isYellow);
                }
            }, packetBuffer -> packetBuffer.writeBoolean(this.isYellow));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer().isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (!context.getClickedFace().equals((Object)Direction.UP)) {
            return InteractionResult.FAIL;
        }
        if (!BlockPaint.canPlaceBlockAt(context.getLevel(), context.getClickedPos().above())) {
            return InteractionResult.FAIL;
        }
        if (!context.getLevel().isEmptyBlock(context.getClickedPos().above())) {
            return InteractionResult.FAIL;
        }
        ItemStack stack1 = context.getItemInHand();
        if (stack1.isEmpty() || !(stack1.getItem() instanceof ItemPainter)) {
            return InteractionResult.FAIL;
        }
        BlockPaint block = this.getSelectedPaint(SlotPainter.getPainterID(stack1));
        if (block == null) {
            return InteractionResult.FAIL;
        }
        BlockState state = (BlockState)block.defaultBlockState().setValue((Property)BlockPaint.FACING, (Comparable)context.getPlayer().getDirection());
        context.getLevel().setBlockAndUpdate(context.getClickedPos().above(), state);
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            stack1.hurtAndBreak(1, serverPlayer.serverLevel(), serverPlayer, item -> {});
        }
        return InteractionResult.SUCCESS;
    }

    private BlockPaint getSelectedPaint(int id) {
        if (id < 0 || id >= ModBlocks.PAINTS.length) {
            return null;
        }
        BlockPaint block = this.isYellow ? (BlockPaint)ModBlocks.YELLOW_PAINTS[id].get() : (BlockPaint)ModBlocks.PAINTS[id].get();
        return block;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> textComponents, TooltipFlag tooltipFlag) {
        BlockPaint paint = this.getSelectedPaint(SlotPainter.getPainterID(stack));
        if (paint != null) {
            textComponents.add((Component)Component.translatable((String)"tooltip.painter", (Object[])new Object[]{Component.translatable((String)paint.getDescriptionId()).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, textComponents, tooltipFlag);
    }
}

