/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ItemBattery
extends Item {
    public ItemBattery() {
        super(new Item.Properties().stacksTo(1).durability(500));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"tooltip.battery_energy", (Object[])new Object[]{Component.literal((String)String.valueOf(this.getEnergy(stack))).withStyle(ChatFormatting.DARK_GRAY)}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.battery").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        IEnergyStorage storage;
        if (context.getLevel().getBlockState(context.getClickedPos()).getBlock().equals(ModBlocks.GENERATOR.get()) && (storage = EnergyUtils.getEnergyStorage(context.getLevel(), context.getClickedPos(), context.getClickedFace())) != null) {
            ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
            int energyToFill = stack.getDamageValue();
            int amount = storage.extractEnergy(energyToFill, false);
            stack.setDamageValue(energyToFill - amount);
            context.getPlayer().setItemInHand(context.getHand(), stack);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public int getEnergy(ItemStack stack) {
        return this.getMaxDamage(stack) - this.getDamage(stack);
    }

    public void setEnergy(ItemStack stack, int energy) {
        this.setDamage(stack, Math.max(this.getMaxDamage(stack) - energy, 0));
    }

    public IEnergyStorage getEnergyHandler(ItemStack stack) {
        return new BatteryEnergyStorage(stack);
    }

    public class BatteryEnergyStorage
    implements IEnergyStorage {
        private ItemStack stack;

        public BatteryEnergyStorage(ItemStack stack) {
            this.stack = stack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int amount = Math.min(maxReceive, ItemBattery.this.getMaxDamage(this.stack) - ItemBattery.this.getEnergy(this.stack));
            if (!simulate) {
                ItemBattery.this.setEnergy(this.stack, ItemBattery.this.getEnergy(this.stack) + amount);
            }
            return amount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ItemBattery.this.getEnergy(this.stack);
        }

        public int getMaxEnergyStored() {
            return ItemBattery.this.getMaxDamage(this.stack);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

