/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.integration.jei;

import de.maxhenkel.car.blocks.BlockCarWorkshop;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.integration.jei.CarRecipe;
import de.maxhenkel.car.integration.jei.JEIPlugin;
import de.maxhenkel.tools.EntityTools;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class CarRecipeCategory
implements IRecipeCategory<CarRecipe> {
    private IGuiHelper helper;
    private static final int RECIPE_WIDTH = 175;
    private static final int RECIPE_HEIGHT = 54;
    private EntityTools.SimulatedCarRenderer renderer = new EntityTools.SimulatedCarRenderer();

    public CarRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public RecipeType<CarRecipe> getRecipeType() {
        return JEIPlugin.CATEGORY_CAR_WORKSHOP;
    }

    public IDrawable getBackground() {
        return this.helper.createDrawable(ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/jei_car_workshop_crafting.png"), 0, 0, 175, 54);
    }

    public IDrawable getIcon() {
        return this.helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.CAR_WORKSHOP.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CarRecipe recipe, IFocusGroup focuses) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 5; ++x) {
                ItemStack stack;
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
                int index = x + y * 5;
                if (index >= recipe.getInputs().size() || (stack = recipe.getInputs().get(index)).isEmpty()) continue;
                slot.addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
            }
        }
    }

    public Component getTitle() {
        return ((BlockCarWorkshop)ModBlocks.CAR_WORKSHOP.get()).getName();
    }

    public void draw(CarRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.renderer.render(guiGraphics, recipe.getCar(), 145, 41, 18);
    }
}

