/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.sounds.ModSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class SlotRepairKit
extends Slot {
    private EntityCarDamageBase car;
    private Player player;

    public SlotRepairKit(EntityCarDamageBase car, int index, int xPosition, int yPosition, Player player) {
        super((Container)new SimpleContainer(1), index, xPosition, yPosition);
        this.car = car;
        this.player = player;
    }

    public void set(ItemStack stack) {
        if (!stack.getItem().equals(ModItems.REPAIR_KIT.get())) {
            return;
        }
        if (this.car.getDamage() >= 90.0f) {
            stack.shrink(1);
            float damage = this.car.getDamage() - ((Double)Main.SERVER_CONFIG.repairKitRepairAmount.get()).floatValue();
            if (damage >= 0.0f) {
                this.car.setDamage(damage);
            }
            ModSounds.playSound((SoundEvent)ModSounds.RATCHET.get(), this.car.level(), this.car.blockPosition(), null, SoundSource.BLOCKS);
        }
        if (!this.player.getInventory().add(stack)) {
            Containers.dropItemStack((Level)this.car.level(), (double)this.car.getX(), (double)this.car.getY(), (double)this.car.getZ(), (ItemStack)stack);
        }
    }

    public boolean mayPlace(ItemStack stack) {
        return stack.getItem().equals(ModItems.REPAIR_KIT.get());
    }
}

