/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.net.MessageEditSign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiSign
extends ScreenBase<ContainerSign> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_sign.png");
    private TileEntitySign sign;
    protected int guiLeft;
    protected int guiTop;
    protected Button buttonSwitch;
    protected Button buttonSubmit;
    protected Button buttonCancel;
    protected EditBox text1;
    protected EditBox text2;
    protected EditBox text3;
    protected EditBox text4;
    protected String[] text;
    protected boolean front = true;

    public GuiSign(ContainerSign containerSign, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, containerSign, playerInventory, title);
        this.sign = containerSign.getSign();
        this.imageWidth = 176;
        this.imageHeight = 142;
        this.text = this.sign.getSignText();
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.imageWidth) / 2;
        this.guiTop = (this.height - this.imageHeight) / 2;
        this.text1 = this.initTextField(0, 0);
        this.text2 = this.initTextField(1, 20);
        this.text3 = this.initTextField(2, 40);
        this.text4 = this.initTextField(3, 60);
        this.setInitialFocus((GuiEventListener)this.text1);
        this.buttonSubmit = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.submit"), button -> {
            this.save();
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageEditSign(this.sign.getBlockPos(), this.text), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Minecraft.getInstance().setScreen(null);
        }).bounds(this.guiLeft + 20, this.guiTop + this.imageHeight - 25, 50, 20).build());
        this.buttonCancel = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.cancel"), button -> Minecraft.getInstance().setScreen(null)).bounds(this.guiLeft + this.imageWidth - 50 - 15, this.guiTop + this.imageHeight - 25, 50, 20).build());
        this.buttonSwitch = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.sign.back"), button -> {
            this.save();
            boolean bl = this.front = !this.front;
            if (this.front) {
                this.text1.setValue(this.text[0]);
                this.text2.setValue(this.text[1]);
                this.text3.setValue(this.text[2]);
                this.text4.setValue(this.text[3]);
                this.buttonSwitch.setMessage((Component)Component.translatable((String)"gui.sign.back"));
            } else {
                this.text1.setValue(this.text[4]);
                this.text2.setValue(this.text[5]);
                this.text3.setValue(this.text[6]);
                this.text4.setValue(this.text[7]);
                this.buttonSwitch.setMessage((Component)Component.translatable((String)"gui.sign.front"));
            }
        }).bounds(this.guiLeft + 5, this.guiTop + 49 + 10, 46, 20).build());
    }

    private EditBox initTextField(int id, int height) {
        EditBox field = new EditBox(this.font, this.guiLeft + 54, this.guiTop + 30 + height, 114, 16, (Component)Component.empty());
        field.setTextColor(-1);
        field.setTextColorUneditable(-1);
        field.setBordered(true);
        field.setMaxLength(20);
        field.setValue(this.text[id]);
        this.addRenderableWidget((GuiEventListener)field);
        return field;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        String s = this.front ? Component.translatable((String)"gui.sign.front").getString() : Component.translatable((String)"gui.sign.back").getString();
        guiGraphics.drawString(this.font, Component.translatable((String)"gui.sign", (Object[])new Object[]{s}).getVisualOrderText(), 54, 10, 0x404040, false);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return this.text1.keyPressed(key, scanCode, modifiers) || this.text1.canConsumeInput() || this.text2.keyPressed(key, scanCode, modifiers) || this.text2.canConsumeInput() || this.text3.keyPressed(key, scanCode, modifiers) || this.text3.canConsumeInput() || this.text4.keyPressed(key, scanCode, modifiers) || this.text4.canConsumeInput() || super.keyPressed(key, scanCode, modifiers);
    }

    private void save() {
        if (this.front) {
            this.text[0] = this.text1.getValue();
            this.text[1] = this.text2.getValue();
            this.text[2] = this.text3.getValue();
            this.text[3] = this.text4.getValue();
        } else {
            this.text[4] = this.text1.getValue();
            this.text[5] = this.text2.getValue();
            this.text[6] = this.text3.getValue();
            this.text[7] = this.text4.getValue();
        }
    }

    public void resize(Minecraft mc, int x, int y) {
        String txt1 = this.text1.getValue();
        String txt2 = this.text2.getValue();
        String txt3 = this.text3.getValue();
        String txt4 = this.text4.getValue();
        this.init(mc, x, y);
        this.text1.setValue(txt1);
        this.text2.setValue(txt2);
        this.text3.setValue(txt3);
        this.text4.setValue(txt4);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

