/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.tools.EntityTools;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiCarWorkshopRepair
extends ScreenBase<ContainerCarWorkshopRepair> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"car", (String)"textures/gui/gui_car_workshop_repair.png");
    private Player player;
    private TileEntityCarWorkshop tile;
    private Button buttonBack;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopRepair(ContainerCarWorkshopRepair container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = container.getPlayer();
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.imageWidth = 176;
        this.imageHeight = 222;
    }

    protected void init() {
        super.init();
        this.buttonRepair = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.repair_car"), button -> {
            if (this.tile.getLevel().isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageRepairCar(this.tile.getBlockPos(), this.player), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).bounds(this.leftPos + this.imageWidth - 7 - 60, this.topPos + 105, 60, 20).build());
        this.buttonRepair.active = false;
        this.buttonBack = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.car.back"), button -> {
            if (this.tile.getLevel().isClientSide) {
                PacketDistributor.sendToServer((CustomPacketPayload)new MessageOpenCarWorkshopGui(this.tile.getBlockPos(), this.player, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }).bounds(this.leftPos + 7, this.topPos + 105, 60, 20).build());
        this.buttonBack.active = true;
    }

    @Override
    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.tile.getDisplayName().getVisualOrderText(), 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.player.getInventory().getDisplayName().getVisualOrderText(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        EntityCarBase carTop = this.tile.getCarOnTop();
        if (!(carTop instanceof EntityCarDamageBase)) {
            this.buttonRepair.active = false;
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carTop;
        if (mouseX >= this.leftPos + 52 && mouseX <= this.leftPos + 123 && mouseY >= this.topPos + 81 && mouseY <= this.topPos + 90) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.translatable((String)"tooltip.damage", (Object[])new Object[]{Float.valueOf(MathUtils.round(car.getDamage(), 2))}).getVisualOrderText());
            guiGraphics.renderTooltip(this.font, list, mouseX - this.leftPos, mouseY - this.topPos);
        }
        this.buttonRepair.active = this.tile.areRepairItemsInside() && car.getDamage() > 0.0f;
        this.drawCar(guiGraphics, carTop);
    }

    public void containerTick() {
        super.containerTick();
        this.carRenderer.tick();
    }

    private void drawCar(GuiGraphics guiGraphics, EntityCarBase car) {
        this.carRenderer.render(guiGraphics, car, this.imageWidth / 2, 55, 23);
    }

    public double getDamagePercent(EntityCarDamageBase car) {
        float dmg = car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.drawDamage(guiGraphics);
    }

    public void drawDamage(GuiGraphics guiGraphics) {
        EntityCarBase car = this.tile.getCarOnTop();
        if (!(car instanceof EntityCarDamageBase)) {
            return;
        }
        EntityCarDamageBase c = (EntityCarDamageBase)car;
        double percent = 100.0 - this.getDamagePercent(c);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int scaled = (int)(72.0 * percent / 100.0);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(GUI_TEXTURE, i + 52, j + 81, 176, 0, scaled, 10);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

