/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.parts;

import com.mojang.math.Axis;
import de.maxhenkel.car.corelib.client.obj.OBJModel;
import de.maxhenkel.car.corelib.client.obj.OBJModelInstance;
import de.maxhenkel.car.corelib.client.obj.OBJModelOptions;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.Part;
import de.maxhenkel.car.entity.car.parts.PartBody;
import de.maxhenkel.car.entity.car.parts.PartModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3d;

public class PartWheelBase
extends PartModel {
    protected float rotationModifier;
    protected float stepHeight;

    public PartWheelBase(OBJModel model, ResourceLocation texture, float rotationModifier, float stepHeight) {
        super(model, texture);
        this.rotationModifier = rotationModifier;
        this.stepHeight = stepHeight;
    }

    public float getStepHeight() {
        return this.stepHeight;
    }

    public float getRotationModifier() {
        return this.rotationModifier;
    }

    @Override
    public boolean validate(List<Part> parts, List<Component> messages) {
        for (Part part : parts) {
            PartBody body;
            if (!(part instanceof PartBody) || (body = (PartBody)part).canFitWheel(this)) continue;
            messages.add((Component)Component.translatable((String)"message.parts.wrong_wheel_type"));
            return false;
        }
        return super.validate(parts, messages);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OBJModelInstance<EntityGenericCar>> getInstances(EntityGenericCar car) {
        void var5_8;
        ArrayList<OBJModelInstance<EntityGenericCar>> list = new ArrayList<OBJModelInstance<EntityGenericCar>>();
        Vector3d[] wheelOffsets = new Vector3d[]{};
        for (Part part : car.getModelParts()) {
            if (!(part instanceof PartBody)) continue;
            wheelOffsets = ((PartBody)part).getWheelOffsets();
        }
        ArrayList<PartWheelBase> wheels = new ArrayList<PartWheelBase>();
        for (Part part : car.getModelParts()) {
            if (!(part instanceof PartWheelBase)) continue;
            wheels.add((PartWheelBase)part);
        }
        boolean bl = false;
        while (var5_8 < wheelOffsets.length && var5_8 < wheels.size()) {
            list.add(new OBJModelInstance<EntityGenericCar>(((PartWheelBase)wheels.get((int)var5_8)).model, new OBJModelOptions<EntityGenericCar>(((PartWheelBase)wheels.get((int)var5_8)).texture, wheelOffsets[var5_8], null, (c, matrixStack, partialTicks) -> matrixStack.mulPose(Axis.XP.rotationDegrees(-car.getWheelRotation(partialTicks))))));
            ++var5_8;
        }
        return list;
    }
}

