/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class EntityCarLockBase
extends EntityCarInventoryBase {
    private static final EntityDataAccessor<Boolean> LOCKED = SynchedEntityData.defineId(EntityCarInventoryBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public EntityCarLockBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean canPlayerEnterCar(Player player) {
        if (this.isLocked()) {
            player.displayClientMessage((Component)Component.translatable((String)"message.car_locked"), true);
            return false;
        }
        return super.canPlayerEnterCar(player);
    }

    @Override
    public void destroyCar(Player player, boolean dropParts) {
        if (this.isLocked() && !player.hasPermissions(2)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.car_locked"), true);
            return;
        }
        super.destroyCar(player, dropParts);
    }

    @Override
    public boolean canPlayerAccessInventoryExternal(Player player) {
        if (this.isLocked()) {
            return false;
        }
        return super.canPlayerAccessInventoryExternal(player);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOCKED, (Object)Boolean.FALSE);
    }

    public void setLocked(boolean locked, boolean playsound) {
        if (locked && playsound) {
            this.playLockSound();
        } else if (!locked && playsound) {
            this.playUnLockSound();
        }
        this.entityData.set(LOCKED, (Object)locked);
    }

    public boolean isLocked() {
        return (Boolean)this.entityData.get(LOCKED);
    }

    public void playLockSound() {
        ModSounds.playSound(this.getLockSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f);
    }

    public void playUnLockSound() {
        ModSounds.playSound(this.getUnLockSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f);
    }

    public SoundEvent getLockSound() {
        return (SoundEvent)ModSounds.CAR_LOCK.get();
    }

    public SoundEvent getUnLockSound() {
        return (SoundEvent)ModSounds.CAR_UNLOCK.get();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("locked", this.isLocked());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setLocked(compound.getBoolean("locked"), false);
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        UUID uuid;
        ItemStack stack = player.getItemInHand(hand);
        if (!this.isLocked() && player.isShiftKeyDown() && player.getAbilities().instabuild && !stack.isEmpty() && stack.getItem().equals(ModItems.KEY.get()) && (uuid = ItemKey.getCar(stack)) == null) {
            ItemKey.setCar(stack, this.getUUID());
            return InteractionResult.CONSUME;
        }
        return super.interact(player, hand);
    }
}

