/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.corelib.item.ItemUtils;
import de.maxhenkel.car.entity.car.base.EntityCarLockBase;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.car.parts.PartLicensePlateHolder;
import de.maxhenkel.car.items.ItemLicensePlate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;

public abstract class EntityCarLicensePlateBase
extends EntityCarLockBase {
    private static final EntityDataAccessor<String> LICENSE_PLATE = SynchedEntityData.defineId(EntityCarLicensePlateBase.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public EntityCarLicensePlateBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LICENSE_PLATE, (Object)"");
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        String text;
        ItemStack stack;
        if (player.isShiftKeyDown() && !this.isLocked() && this.hasLicensePlateHolder() && (stack = player.getItemInHand(hand)).getItem() instanceof ItemLicensePlate && !(text = ItemLicensePlate.getText(stack)).isEmpty()) {
            ItemUtils.decrItemStack(stack, player);
            player.setItemInHand(hand, stack);
            this.setLicensePlate(text);
            return InteractionResult.CONSUME;
        }
        return super.interact(player, hand);
    }

    public boolean hasLicensePlateHolder() {
        if (!(this instanceof EntityGenericCar)) {
            return false;
        }
        EntityGenericCar car = (EntityGenericCar)this;
        return car.getPartByClass(PartLicensePlateHolder.class) != null;
    }

    public String getLicensePlate() {
        return (String)this.entityData.get(LICENSE_PLATE);
    }

    public void setLicensePlate(String plate) {
        this.entityData.set(LICENSE_PLATE, (Object)plate);
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("license_plate", this.getLicensePlate());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setLicensePlate(compound.getString("license_plate"));
    }

    public abstract Vector3d getLicensePlateOffset();
}

