/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.DamageSourceCar;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBatteryBase;
import de.maxhenkel.car.entity.car.base.EntityVehicleBase;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.sounds.SoundLoopHigh;
import de.maxhenkel.car.sounds.SoundLoopIdle;
import de.maxhenkel.car.sounds.SoundLoopStart;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class EntityCarBase
extends EntityVehicleBase {
    private float wheelRotation;
    @OnlyIn(value=Dist.CLIENT)
    private boolean collidedLastTick;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopStart startLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopIdle idleLoop;
    @OnlyIn(value=Dist.CLIENT)
    private SoundLoopHigh highLoop;
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> STARTED = SynchedEntityData.defineId(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FORWARD = SynchedEntityData.defineId(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BACKWARD = SynchedEntityData.defineId(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LEFT = SynchedEntityData.defineId(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.defineId(EntityCarBase.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final BlockingQueue<Runnable> tasks = new LinkedBlockingQueue<Runnable>();
    @OnlyIn(value=Dist.CLIENT)
    private boolean startedLast;

    public EntityCarBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public float maxUpStep() {
        return 0.5f;
    }

    public abstract float getMaxSpeed();

    public abstract float getMaxReverseSpeed();

    public abstract float getAcceleration();

    public abstract float getMaxRotationSpeed();

    public abstract float getMinRotationSpeed();

    public abstract float getRollResistance();

    public abstract float getRotationModifier();

    public abstract float getPitch();

    @Override
    public void tick() {
        Runnable task;
        super.tick();
        while ((task = (Runnable)this.tasks.poll()) != null) {
            task.run();
        }
        if (this.isStarted() && !this.canEngineStayOn()) {
            this.setStarted(false);
        }
        this.updateGravity();
        this.controlCar();
        this.checkPush();
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.level().isClientSide) {
            this.updateSounds();
        }
        this.updateWheelRotation();
    }

    public void centerCar() {
        Direction facing = this.getDirection();
        switch (facing) {
            case SOUTH: {
                this.setYRot(0.0f);
                break;
            }
            case NORTH: {
                this.setYRot(180.0f);
                break;
            }
            case EAST: {
                this.setYRot(-90.0f);
                break;
            }
            case WEST: {
                this.setYRot(90.0f);
            }
        }
    }

    @Override
    public boolean canCollideWith(Entity entityIn) {
        float speed;
        if (!this.level().isClientSide && ((Boolean)Main.SERVER_CONFIG.damageEntities.get()).booleanValue() && entityIn instanceof LivingEntity && !this.getPassengers().contains(entityIn) && entityIn.getBoundingBox().intersects(this.getBoundingBox()) && (speed = this.getSpeed()) > 0.35f) {
            float damage = speed * 10.0f;
            this.tasks.add(() -> {
                ServerLevel serverLevel = (ServerLevel)this.level();
                Optional holder = serverLevel.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolder(DamageSourceCar.DAMAGE_CAR_TYPE);
                holder.ifPresent(damageTypeReference -> entityIn.hurt(new DamageSource((Holder)damageTypeReference, (Entity)this), damage));
            });
        }
        return super.canCollideWith(entityIn);
    }

    public void checkPush() {
        List list = this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().expandTowards(0.2, 0.0, 0.2).expandTowards(-0.2, 0.0, -0.2));
        for (Player player : list) {
            if (player.hasPassenger((Entity)this) || !player.isShiftKeyDown()) continue;
            double motX = EntityCarBase.calculateMotionX(0.05f, player.getYRot());
            double motZ = EntityCarBase.calculateMotionZ(0.05f, player.getYRot());
            this.move(MoverType.PLAYER, new Vec3(motX, 0.0, motZ));
            return;
        }
    }

    public boolean canEngineStayOn() {
        return !this.isInWater() && !this.isInLava();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateSounds() {
        if (this.getSpeed() == 0.0f && this.isStarted()) {
            if (!this.startedLast) {
                this.checkStartLoop();
            } else if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
                if (this.startLoop != null) {
                    this.startLoop.setDonePlaying();
                    this.startLoop = null;
                }
                this.checkIdleLoop();
            }
        }
        if (this.getSpeed() != 0.0f && this.isStarted()) {
            this.checkHighLoop();
        }
        this.startedLast = this.isStarted();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSoundPlaying(SoundInstance sound) {
        if (sound == null) {
            return false;
        }
        return Minecraft.getInstance().getSoundManager().isActive(sound);
    }

    public void destroyCar(Player player, boolean dropParts) {
        this.kill();
    }

    private void controlCar() {
        if (!this.isVehicle()) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        float modifier = this.getModifier();
        float maxSp = this.getMaxSpeed() * modifier;
        float maxBackSp = this.getMaxReverseSpeed() * modifier;
        float speed = MathUtils.subtractToZero(this.getSpeed(), this.getRollResistance());
        if (this.isForward() && speed <= maxSp) {
            speed = Math.min(speed + this.getAcceleration(), maxSp);
        }
        if (this.isBackward() && speed >= -maxBackSp) {
            speed = Math.max(speed - this.getAcceleration(), -maxBackSp);
        }
        this.setSpeed(speed);
        float rotationSpeed = 0.0f;
        if (Math.abs(speed) > 0.02f) {
            rotationSpeed = Mth.abs((float)(this.getRotationModifier() / (float)Math.pow(speed, 2.0)));
            rotationSpeed = Mth.clamp((float)rotationSpeed, (float)this.getMinRotationSpeed(), (float)this.getMaxRotationSpeed());
        }
        this.deltaRotation = 0.0f;
        if (speed < 0.0f) {
            rotationSpeed = -rotationSpeed;
        }
        if (this.isLeft()) {
            this.deltaRotation -= rotationSpeed;
        }
        if (this.isRight()) {
            this.deltaRotation += rotationSpeed;
        }
        this.setYRot(this.getYRot() + this.deltaRotation);
        float delta = Math.abs(this.getYRot() - this.yRotO);
        while (this.getYRot() > 180.0f) {
            this.setYRot(this.getYRot() - 360.0f);
            this.yRotO = this.getYRot() - delta;
        }
        while (this.getYRot() <= -180.0f) {
            this.setYRot(this.getYRot() + 360.0f);
            this.yRotO = delta + this.getYRot();
        }
        if (this.horizontalCollision) {
            if (this.level().isClientSide && !this.collidedLastTick) {
                this.onCollision(speed);
                this.collidedLastTick = true;
            }
        } else {
            this.setDeltaMovement(EntityCarBase.calculateMotionX(this.getSpeed(), this.getYRot()), this.getDeltaMovement().y, EntityCarBase.calculateMotionZ(this.getSpeed(), this.getYRot()));
            if (this.level().isClientSide) {
                this.collidedLastTick = false;
            }
        }
    }

    public float getModifier() {
        BlockPos pos = new BlockPos((int)this.getX(), (int)(this.getY() - 0.1), (int)this.getZ());
        BlockState state = this.level().getBlockState(pos);
        if (state.isAir() || Main.SERVER_CONFIG.carDriveBlockList.stream().anyMatch(tag -> tag.contains(state.getBlock()))) {
            return ((Double)Main.SERVER_CONFIG.carOnroadSpeed.get()).floatValue();
        }
        return ((Double)Main.SERVER_CONFIG.carOffroadSpeed.get()).floatValue();
    }

    public void onCollision(float speed) {
        if (this.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageCrash(speed, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.setSpeed(0.01f);
        this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
    }

    public boolean canPlayerDriveCar(Player player) {
        if (player.equals((Object)this.getDriver()) && this.isStarted()) {
            return true;
        }
        if (this.isInWater() || this.isInLava()) {
            return false;
        }
        return false;
    }

    private void updateGravity() {
        if (this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().x, 0.0, this.getDeltaMovement().z);
            return;
        }
        this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y - 0.2, this.getDeltaMovement().z);
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, Player player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.level().isClientSide && needsUpdate) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageControlCar(forward, backward, left, right, player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void startCarEngine() {
        Player player = this.getDriver();
        if (player != null && this.canStartCarEngine(player)) {
            this.setStarted(true);
        }
    }

    public boolean canStartCarEngine(Player player) {
        return !this.isInWater() && !this.isInLava();
    }

    public abstract double getPlayerYOffset();

    public boolean canPlayerEnterCar(Player player) {
        return true;
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.canPlayerEnterCar(player)) {
            return InteractionResult.FAIL;
        }
        return super.interact(player, hand);
    }

    public float getKilometerPerHour() {
        return this.getSpeed() * 20.0f * 60.0f * 60.0f / 1000.0f;
    }

    public float getWheelRotationAmount() {
        return 120.0f * this.getSpeed();
    }

    public void updateWheelRotation() {
        this.wheelRotation += this.getWheelRotationAmount();
    }

    public float getWheelRotation(float partialTicks) {
        return this.wheelRotation + this.getWheelRotationAmount() * partialTicks;
    }

    public void openCarGUI(Player player) {
        if (this.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageCarGui(player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isAccelerating() {
        boolean b = (this.isForward() || this.isBackward()) && !this.horizontalCollision;
        return b && this.isStarted();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STARTED, (Object)false);
        builder.define(SPEED, (Object)Float.valueOf(0.0f));
        builder.define(FORWARD, (Object)false);
        builder.define(BACKWARD, (Object)false);
        builder.define(LEFT, (Object)false);
        builder.define(RIGHT, (Object)false);
    }

    public void setSpeed(float speed) {
        this.entityData.set(SPEED, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.entityData.get(SPEED)).floatValue();
    }

    public void setStarted(boolean started) {
        this.setStarted(started, true, false);
    }

    public void setStarted(boolean started, boolean playStopSound, boolean playFailSound) {
        if (!started && playStopSound) {
            this.playStopSound();
        } else if (!started && playFailSound) {
            this.playFailSound();
        }
        if (started) {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
        this.entityData.set(STARTED, (Object)started);
    }

    public boolean isStarted() {
        return (Boolean)this.entityData.get(STARTED);
    }

    public void setForward(boolean forward) {
        this.entityData.set(FORWARD, (Object)forward);
    }

    public boolean isForward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.entityData.get(FORWARD);
    }

    public void setBackward(boolean backward) {
        this.entityData.set(BACKWARD, (Object)backward);
    }

    public boolean isBackward() {
        if (this.getDriver() == null || !this.canPlayerDriveCar(this.getDriver())) {
            return false;
        }
        return (Boolean)this.entityData.get(BACKWARD);
    }

    public void setLeft(boolean left) {
        this.entityData.set(LEFT, (Object)left);
    }

    public boolean isLeft() {
        return (Boolean)this.entityData.get(LEFT);
    }

    public void setRight(boolean right) {
        this.entityData.set(RIGHT, (Object)right);
    }

    public boolean isRight() {
        return (Boolean)this.entityData.get(RIGHT);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setStarted(compound.getBoolean("started"), false, false);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putBoolean("started", this.isStarted());
    }

    public void playStopSound() {
        ModSounds.playSound(this.getStopSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f);
    }

    public void playFailSound() {
        ModSounds.playSound(this.getFailSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f);
    }

    public void playCrashSound() {
        ModSounds.playSound(this.getCrashSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f);
    }

    public void playHornSound() {
        ModSounds.playSound(this.getHornSound(), this.level(), this.blockPosition(), null, SoundSource.MASTER, 1.0f);
    }

    public abstract SoundEvent getStopSound();

    public abstract SoundEvent getFailSound();

    public abstract SoundEvent getCrashSound();

    public abstract SoundEvent getStartSound();

    public abstract SoundEvent getStartingSound();

    public abstract SoundEvent getIdleSound();

    public abstract SoundEvent getHighSound();

    public abstract SoundEvent getHornSound();

    @OnlyIn(value=Dist.CLIENT)
    public void checkIdleLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.idleLoop)) {
            this.idleLoop = new SoundLoopIdle(this, this.getIdleSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.idleLoop, this.level());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkHighLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.highLoop)) {
            this.highLoop = new SoundLoopHigh(this, this.getHighSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.highLoop, this.level());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void checkStartLoop() {
        if (!this.isSoundPlaying((SoundInstance)this.startLoop)) {
            this.startLoop = new SoundLoopStart(this, this.getStartSound(), SoundSource.MASTER);
            ModSounds.playSoundLoop(this.startLoop, this.level());
        }
    }

    public void onHornPressed(Player player) {
        if (this.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageCarHorn(true, player), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            if (this instanceof EntityCarBatteryBase) {
                EntityCarBatteryBase car = (EntityCarBatteryBase)this;
                if (car.getBatteryLevel() < 10) {
                    return;
                }
                if (((Boolean)Main.SERVER_CONFIG.useBattery.get()).booleanValue()) {
                    car.setBatteryLevel(car.getBatteryLevel() - 10);
                }
            }
            this.playHornSound();
            if (((Boolean)Main.SERVER_CONFIG.hornFlee.get()).booleanValue()) {
                double radius = 15.0;
                List list = this.level().getEntitiesOfClass(Monster.class, new AABB(this.getX() - radius, this.getY() - radius, this.getZ() - radius, this.getX() + radius, this.getY() + radius, this.getZ() + radius));
                for (Monster ent : list) {
                    this.fleeEntity(ent);
                }
            }
        }
    }

    public void fleeEntity(Monster entity) {
        double fleeDistance = 10.0;
        Vec3 vecCar = new Vec3(this.getX(), this.getY(), this.getZ());
        Vec3 vecEntity = new Vec3(entity.getX(), entity.getY(), entity.getZ());
        Vec3 fleeDir = vecEntity.subtract(vecCar);
        fleeDir = fleeDir.normalize();
        entity.getNavigation().moveTo(vecEntity.x + fleeDir.x * fleeDistance, vecEntity.y + fleeDir.y * fleeDistance, vecEntity.z + fleeDir.z * fleeDistance, 2.5);
    }
}

