/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockGenerator;
import de.maxhenkel.car.blocks.BlockGui;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class TileEntityGenerator
extends TileEntityBase
implements ITickableBlockEntity,
IFluidHandler,
IEnergyStorage,
Container {
    public final int maxStorage;
    public int storedEnergy;
    public final int maxMillibuckets;
    protected int currentMillibuckets;
    protected final int energyGeneration;
    protected Fluid currentFluid;
    protected SimpleContainer inventory;
    public final ContainerData FIELDS = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TileEntityGenerator.this.storedEnergy;
                }
                case 1: {
                    return TileEntityGenerator.this.currentMillibuckets;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityGenerator.this.storedEnergy = value;
                    break;
                }
                case 1: {
                    TileEntityGenerator.this.currentMillibuckets = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public TileEntityGenerator(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.GENERATOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.inventory = new SimpleContainer(0);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.generatorEnergyStorage.get();
        this.storedEnergy = 0;
        this.maxMillibuckets = (Integer)Main.SERVER_CONFIG.generatorFluidStorage.get();
        this.currentMillibuckets = 0;
        this.energyGeneration = (Integer)Main.SERVER_CONFIG.generatorEnergyGeneration.get();
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        this.setBlockEnabled(this.isEnabled());
        if (this.currentFluid != null && this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration <= this.maxStorage) {
            --this.currentMillibuckets;
            this.storedEnergy += this.energyGeneration;
            if (this.currentMillibuckets <= 0) {
                this.currentMillibuckets = 0;
                this.currentFluid = null;
            }
        }
        if (this.currentMillibuckets <= 0 && this.currentFluid != null) {
            this.currentMillibuckets = 0;
            this.currentFluid = null;
        }
        if (this.currentFluid == null && this.currentMillibuckets > 0) {
            this.currentMillibuckets = 0;
        }
        this.handlePushEnergy();
        this.setChanged();
    }

    public boolean isValidFuel(Fluid f) {
        return Main.SERVER_CONFIG.generatorValidFuelList.stream().anyMatch(fluidTag -> fluidTag.contains(f));
    }

    private void handlePushEnergy() {
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = EnergyUtils.getEnergyStorageOffset(this.level, this.worldPosition, side);
            if (storage == null) continue;
            EnergyUtils.pushEnergy(this, storage, this.storedEnergy);
        }
    }

    public boolean isEnabled() {
        return this.currentMillibuckets > 0 && this.storedEnergy + this.energyGeneration < this.maxStorage;
    }

    public void setBlockEnabled(boolean enabled) {
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (state.getBlock().equals(ModBlocks.GENERATOR.get()) && (Boolean)state.getValue((Property)BlockGui.POWERED) != enabled) {
            ((BlockGenerator)ModBlocks.GENERATOR.get()).setPowered(this.level, this.worldPosition, state, enabled);
        }
    }

    @Override
    public Component getTranslatedName() {
        return Component.translatable((String)"block.car.generator");
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("stored_energy", this.storedEnergy);
        if (this.currentFluid != null) {
            FluidStack stack = new FluidStack(this.currentFluid, this.currentMillibuckets);
            compound.put("fluid", stack.save(provider));
        }
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        this.storedEnergy = compound.getInt("stored_energy");
        if (compound.contains("fluid")) {
            FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("fluid"));
            this.currentFluid = stack.getFluid();
            this.currentMillibuckets = stack.getAmount();
        }
        super.loadAdditional(compound, provider);
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public ItemStack getItem(int index) {
        return this.inventory.getItem(index);
    }

    public ItemStack removeItem(int index, int count) {
        return this.inventory.removeItem(index, count);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return this.inventory.removeItemNoUpdate(index);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.setItem(index, stack);
    }

    public int getMaxStackSize() {
        return this.inventory.getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public void startOpen(Player player) {
        this.inventory.startOpen(player);
    }

    public void stopOpen(Player player) {
        this.inventory.stopOpen(player);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return this.inventory.canPlaceItem(index, stack);
    }

    public void clearContent() {
        this.inventory.clearContent();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.setChanged();
        }
        return i;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    public int getCurrentMillibuckets() {
        return this.currentMillibuckets;
    }

    @Override
    public ContainerData getFields() {
        return this.FIELDS;
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (this.currentFluid == null) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.currentFluid, this.currentMillibuckets);
    }

    public int getTankCapacity(int tank) {
        return this.maxMillibuckets;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack.getFluid()) && (this.currentFluid == null || this.currentFluid.equals(stack.getFluid()));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.currentFluid == null && this.isValidFuel(resource.getFluid()) || resource.getFluid().equals(this.currentFluid)) {
            int amount = Math.min(this.maxMillibuckets - this.currentMillibuckets, resource.getAmount());
            if (action.execute()) {
                this.currentMillibuckets += amount;
                if (this.currentFluid == null) {
                    this.currentFluid = resource.getFluid();
                }
                this.setChanged();
            }
            return amount;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

