/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.corelib.block.DirectionalVoxelShape;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockGasStationTop
extends BlockBase {
    public static VoxelShape SHAPE_NORTH_SOUTH = Block.box((double)2.0, (double)-16.0, (double)5.0, (double)14.0, (double)15.0, (double)11.0);
    public static VoxelShape SHAPE_NEAST_WEST = Block.box((double)5.0, (double)-16.0, (double)2.0, (double)11.0, (double)15.0, (double)14.0);
    public static VoxelShape SHAPE_SLAB = Block.box((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)-8.0, (double)16.0);
    private static final DirectionalVoxelShape SHAPES = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, SHAPE_NORTH_SOUTH, SHAPE_SLAB).direction(Direction.SOUTH, SHAPE_NORTH_SOUTH, SHAPE_SLAB).direction(Direction.EAST, SHAPE_NEAST_WEST, SHAPE_SLAB).direction(Direction.WEST, SHAPE_NEAST_WEST, SHAPE_SLAB).build();
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);

    public BlockGasStationTop() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(4.0f).sound(SoundType.METAL).pushReaction(PushReaction.BLOCK));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return ((BlockGasStation)ModBlocks.GAS_STATION.get()).useItemOn(itemStack, level.getBlockState(blockPos.below()), level, blockPos.below(), player, interactionHand, blockHitResult);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.get((Direction)state.getValue((Property)FACING));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, worldIn, pos, newState, isMoving);
            BlockState stateDown = worldIn.getBlockState(pos.below());
            if (stateDown.getBlock().equals(ModBlocks.GAS_STATION.get())) {
                worldIn.destroyBlock(pos.below(), false);
            }
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState stateDown = world.getBlockState(pos.below());
        stateDown.getBlock();
        if (stateDown.getBlock().equals(ModBlocks.GAS_STATION.get()) && !player.getAbilities().instabuild) {
            ((BlockGasStation)ModBlocks.GAS_STATION.get()).playerDestroy(world, player, pos.below(), world.getBlockState(pos.below()), world.getBlockEntity(pos.below()), player.getMainHandItem());
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        BlockState stateDown = world.getBlockState(pos.below());
        stateDown.getBlock();
        if (stateDown.getBlock().equals(ModBlocks.GAS_STATION.get())) {
            return ((BlockGasStation)ModBlocks.GAS_STATION.get()).getCloneItemStack(stateDown, target, world, pos.below(), player);
        }
        return super.getCloneItemStack(state, target, world, pos, player);
    }
}

