/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.BlockFluidPipe;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.block.VoxelUtils;
import de.maxhenkel.car.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.TileEntityContainerProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFluidExtractor
extends BlockBase
implements EntityBlock,
IItemBlock,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])Direction.values());
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_NORTH = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_UP = Block.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_DOWN = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    public static final VoxelShape SHAPE_CORE = Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_EXTRACTOR_NORTH = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
    public static final VoxelShape SHAPE_EXTRACTOR_SOUTH = Block.box((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    public static final VoxelShape SHAPE_EXTRACTOR_EAST = Block.box((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_WEST = Block.box((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_UP = Block.box((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final VoxelShape SHAPE_EXTRACTOR_DOWN = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);

    protected BlockFluidExtractor() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(0.5f).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (player.isShiftKeyDown()) {
            return InteractionResult.FAIL;
        }
        BlockEntity te = level.getBlockEntity(blockPos);
        if (!(te instanceof TileEntityFluidExtractor)) {
            return InteractionResult.FAIL;
        }
        TileEntityFluidExtractor fluidExtractor = (TileEntityFluidExtractor)te;
        if (player instanceof ServerPlayer) {
            TileEntityContainerProvider.openGui((ServerPlayer)player, fluidExtractor, (i, playerInventory, playerEntity) -> new ContainerFluidExtractor(i, fluidExtractor, playerInventory));
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getClickedFace().getOpposite();
        return (BlockState)this.getState(context.getLevel(), context.getClickedPos(), facing).setValue((Property)FACING, (Comparable)facing);
    }

    private BlockState getState(Level world, BlockPos pos, Direction except) {
        FluidState ifluidstate = world.getFluidState(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.UP) && BlockFluidPipe.isConnectedTo(world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.DOWN) && BlockFluidPipe.isConnectedTo(world, pos, Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.NORTH) && BlockFluidPipe.isConnectedTo(world, pos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.SOUTH) && BlockFluidPipe.isConnectedTo(world, pos, Direction.SOUTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.EAST) && BlockFluidPipe.isConnectedTo(world, pos, Direction.EAST)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(!except.equals((Object)Direction.WEST) && BlockFluidPipe.isConnectedTo(world, pos, Direction.WEST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.neighborChanged(state, world, pos, block, pos1, b);
        Direction facing = (Direction)world.getBlockState(pos).getValue((Property)FACING);
        world.setBlockAndUpdate(pos, (BlockState)this.getState(world, pos, facing).setValue((Property)FACING, (Comparable)facing));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        BlockState newState = (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
        newState = this.setDirection(newState, rot.rotate(Direction.NORTH), (Boolean)state.getValue((Property)NORTH));
        newState = this.setDirection(newState, rot.rotate(Direction.SOUTH), (Boolean)state.getValue((Property)SOUTH));
        newState = this.setDirection(newState, rot.rotate(Direction.EAST), (Boolean)state.getValue((Property)EAST));
        newState = this.setDirection(newState, rot.rotate(Direction.WEST), (Boolean)state.getValue((Property)WEST));
        return newState;
    }

    private BlockState setDirection(BlockState state, Direction direction, boolean connected) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(connected));
            case Direction.SOUTH -> (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(connected));
            case Direction.EAST -> (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(connected));
            case Direction.WEST -> (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(connected));
            case Direction.UP -> (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(connected));
            case Direction.DOWN -> (BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(connected));
        };
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        BlockState newState = state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
        newState = this.setDirection(newState, mirror.getRotation(Direction.NORTH).rotate(Direction.NORTH), (Boolean)state.getValue((Property)NORTH));
        newState = this.setDirection(newState, mirror.getRotation(Direction.SOUTH).rotate(Direction.SOUTH), (Boolean)state.getValue((Property)SOUTH));
        newState = this.setDirection(newState, mirror.getRotation(Direction.EAST).rotate(Direction.EAST), (Boolean)state.getValue((Property)EAST));
        newState = this.setDirection(newState, mirror.getRotation(Direction.WEST).rotate(Direction.WEST), (Boolean)state.getValue((Property)WEST));
        return newState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, UP, DOWN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_WEST);
        }
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_NORTH, SHAPE_NORTH);
                break;
            }
            case SOUTH: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_SOUTH, SHAPE_SOUTH);
                break;
            }
            case EAST: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_EAST, SHAPE_EAST);
                break;
            }
            case WEST: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_WEST, SHAPE_WEST);
                break;
            }
            case UP: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_UP, SHAPE_UP);
                break;
            }
            case DOWN: {
                shape = VoxelUtils.combine(shape, SHAPE_EXTRACTOR_DOWN, SHAPE_DOWN);
            }
        }
        return shape;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TileEntityFluidExtractor(blockPos, blockState);
    }
}

