/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.entity.EntityCargoPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class CargoPlaneModel
extends AbstractPlaneModel<EntityCargoPlane> {
    private static final OBJModel CARGO_PLANE_MODEL = new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/cargo_plane.obj"));
    private static final Vector3f BODY_OFFSET = new Vector3f(0.0f, 0.5f, 0.0f);
    private static final Vector3f PROPELLER_OFFSET = new Vector3f(0.0f, 1.0f, -1.84375f);
    private static final Vector3f LEFT_WHEEL_OFFSET = new Vector3f(-1.125f, 0.125f, -1.09375f);
    private static final Vector3f RIGHT_WHEEL_OFFSET = new Vector3f(1.125f, 0.125f, -1.09375f);

    public CargoPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityCargoPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.translate(1.000625, -1.25, 1.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else {
            matrixStack.translate(-1.000625, -1.25, 1.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        }
    }

    @Override
    protected Vector3f getLeftWheelOffset(EntityCargoPlane plane) {
        return LEFT_WHEEL_OFFSET;
    }

    @Override
    protected Vector3f getRightWheelOffset(EntityCargoPlane plane) {
        return RIGHT_WHEEL_OFFSET;
    }

    @Override
    protected Vector3f getPropellerOffset(EntityCargoPlane plane) {
        return PROPELLER_OFFSET;
    }

    @Override
    protected Vector3f getBodyOffset(EntityCargoPlane plane) {
        return BODY_OFFSET;
    }

    @Override
    protected OBJModel getBodyModel(EntityCargoPlane plane) {
        return CARGO_PLANE_MODEL;
    }

    @Override
    protected ResourceLocation getBodyTexture(EntityCargoPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: {
                return CRIMSON_MODEL;
            }
            case BAMBOO: {
                return BAMBOO_MODEL;
            }
            case CHERRY: {
                return CHERRY_MODEL;
            }
            case MANGROVE: 
        }
        return MANGROVE_MODEL;
    }
}

