/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.entity.EntityBushPlane;
import de.maxhenkel.plane.entity.render.AbstractPlaneModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class BushPlaneModel
extends AbstractPlaneModel<EntityBushPlane> {
    private static final OBJModel BUSH_PLANE_MODEL = new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/bush_plane.obj"));
    private static final Vector3f BODY_OFFSET = new Vector3f(0.0f, 0.5f, 0.0f);
    private static final Vector3f PROPELLER_OFFSET = new Vector3f(0.0f, 1.0f, -1.84375f);
    private static final Vector3f LEFT_WHEEL_OFFSET = new Vector3f(-0.625f, 0.125f, -1.09375f);
    private static final Vector3f RIGHT_WHEEL_OFFSET = new Vector3f(0.625f, 0.125f, -1.09375f);

    public BushPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    @Override
    protected void translateName(EntityBushPlane plane, PoseStack matrixStack, boolean left) {
        if (left) {
            matrixStack.translate(0.500625, -1.25, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        } else {
            matrixStack.translate(-0.500625, -1.25, 0.0);
            matrixStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        }
    }

    @Override
    protected Vector3f getLeftWheelOffset(EntityBushPlane plane) {
        return LEFT_WHEEL_OFFSET;
    }

    @Override
    protected Vector3f getRightWheelOffset(EntityBushPlane plane) {
        return RIGHT_WHEEL_OFFSET;
    }

    @Override
    protected Vector3f getPropellerOffset(EntityBushPlane plane) {
        return PROPELLER_OFFSET;
    }

    @Override
    protected Vector3f getBodyOffset(EntityBushPlane plane) {
        return BODY_OFFSET;
    }

    @Override
    protected OBJModel getBodyModel(EntityBushPlane plane) {
        return BUSH_PLANE_MODEL;
    }

    @Override
    protected ResourceLocation getBodyTexture(EntityBushPlane plane) {
        switch (plane.getPlaneType()) {
            default: {
                return OAK_MODEL;
            }
            case DARK_OAK: {
                return DARK_OAK_MODEL;
            }
            case SPRUCE: {
                return SPRUCE_MODEL;
            }
            case JUNGLE: {
                return JUNGLE_MODEL;
            }
            case BIRCH: {
                return BIRCH_MODEL;
            }
            case ACACIA: {
                return ACACIA_MODEL;
            }
            case WARPED: {
                return WARPED_MODEL;
            }
            case CRIMSON: {
                return CRIMSON_MODEL;
            }
            case BAMBOO: {
                return BAMBOO_MODEL;
            }
            case CHERRY: {
                return CHERRY_MODEL;
            }
            case MANGROVE: 
        }
        return MANGROVE_MODEL;
    }
}

