/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.plane.corelib.client.obj.OBJModel;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import de.maxhenkel.plane.entity.EntityPlaneWheelBase;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public abstract class AbstractPlaneModel<T extends EntityPlaneBase>
extends EntityRenderer<T> {
    protected static final OBJModel WHEEL = new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/wheel.obj"));
    protected static final OBJModel PROPELLER = new OBJModel(ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"models/entity/propeller.obj"));
    protected static final ResourceLocation WHEEL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"plane", (String)"textures/entity/wheel.png");
    protected static final ResourceLocation PROPELLER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/spruce_planks.png");
    protected static final ResourceLocation OAK_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/oak_planks.png");
    protected static final ResourceLocation DARK_OAK_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/dark_oak_planks.png");
    protected static final ResourceLocation BIRCH_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/birch_planks.png");
    protected static final ResourceLocation JUNGLE_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/jungle_planks.png");
    protected static final ResourceLocation ACACIA_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/acacia_planks.png");
    protected static final ResourceLocation SPRUCE_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/spruce_planks.png");
    protected static final ResourceLocation WARPED_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/warped_planks.png");
    protected static final ResourceLocation CRIMSON_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/crimson_planks.png");
    protected static final ResourceLocation BAMBOO_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/bamboo_planks.png");
    protected static final ResourceLocation CHERRY_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/cherry_planks.png");
    protected static final ResourceLocation MANGROVE_MODEL = ResourceLocation.withDefaultNamespace((String)"textures/block/mangrove_planks.png");
    protected static final float MODEL_SCALE = 0.0625f;
    public static final float MAX_TEXT_SCALE = 0.02f;
    public static final float MAX_TEXT_WIDTH = 0.9f;

    protected AbstractPlaneModel(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(T plane, float yRot, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render(plane, yRot, partialTicks, poseStack, buffer, light);
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yRot));
        float pitch = ((EntityPlaneBase)((Object)plane)).xRotO + (plane.getXRot() - ((EntityPlaneBase)((Object)plane)).xRotO) * partialTicks;
        Vec3 bodyCenter = ((EntityPlaneBase)((Object)plane)).getBodyRotationCenter();
        poseStack.rotateAround(Axis.XN.rotationDegrees(pitch), (float)bodyCenter.x, (float)bodyCenter.y, (float)bodyCenter.z);
        poseStack.pushPose();
        Vector3f leftWheelOffset = this.getLeftWheelOffset(plane);
        poseStack.translate(leftWheelOffset.x, leftWheelOffset.y, leftWheelOffset.z);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-((EntityPlaneWheelBase)((Object)plane)).getWheelRotation(partialTicks)));
        WHEEL.render(WHEEL_TEXTURE, poseStack, buffer, light);
        poseStack.popPose();
        poseStack.pushPose();
        Vector3f rightWheelOffset = this.getRightWheelOffset(plane);
        poseStack.translate(rightWheelOffset.x, rightWheelOffset.y, rightWheelOffset.z);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.mulPose(Axis.XP.rotationDegrees(-((EntityPlaneWheelBase)((Object)plane)).getWheelRotation(partialTicks)));
        WHEEL.render(WHEEL_TEXTURE, poseStack, buffer, light);
        poseStack.popPose();
        poseStack.pushPose();
        Vector3f propellerOffset = this.getPropellerOffset(plane);
        poseStack.translate(propellerOffset.x, propellerOffset.y, propellerOffset.z);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(-((EntityPlaneWheelBase)((Object)plane)).getPropellerRotation(partialTicks)));
        PROPELLER.render(PROPELLER_TEXTURE, poseStack, buffer, light);
        poseStack.popPose();
        poseStack.pushPose();
        Vector3f bodyOffset = this.getBodyOffset(plane);
        poseStack.translate(bodyOffset.x, bodyOffset.y, bodyOffset.z);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        this.getBodyModel(plane).render(this.getBodyTexture(plane), poseStack, buffer, light);
        poseStack.popPose();
        if (plane.hasCustomName()) {
            this.drawName(plane, plane.getCustomName(), poseStack, buffer, light, true);
            this.drawName(plane, plane.getCustomName(), poseStack, buffer, light, false);
        }
        poseStack.popPose();
    }

    protected void drawName(T plane, Component name, PoseStack matrixStack, MultiBufferSource buffer, int light, boolean left) {
        matrixStack.pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.scale(1.0f, -1.0f, 1.0f);
        this.translateName(plane, matrixStack, left);
        int textWidth = this.getFont().width((FormattedText)name);
        float textScale = Math.min(0.02f, 0.9f / (float)textWidth);
        matrixStack.translate(-(textScale * (float)textWidth) / 2.0f, 0.0f, 0.0f);
        matrixStack.scale(textScale, textScale, textScale);
        this.getFont().drawInBatch(name, 0.0f, 0.0f, 0xFFFFFF, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, light);
        matrixStack.popPose();
    }

    protected abstract void translateName(T var1, PoseStack var2, boolean var3);

    protected abstract Vector3f getLeftWheelOffset(T var1);

    protected abstract Vector3f getRightWheelOffset(T var1);

    protected abstract Vector3f getPropellerOffset(T var1);

    protected abstract Vector3f getBodyOffset(T var1);

    protected abstract OBJModel getBodyModel(T var1);

    protected abstract ResourceLocation getBodyTexture(T var1);

    public ResourceLocation getTextureLocation(T entity) {
        return null;
    }

    protected boolean shouldShowName(T entity) {
        return false;
    }
}

