/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneControlBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class EntityPlaneFuelBase
extends EntityPlaneControlBase
implements IFluidHandler {
    private static final EntityDataAccessor<Integer> FUEL = SynchedEntityData.defineId(EntityPlaneFuelBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> FUEL_TYPE = SynchedEntityData.defineId(EntityPlaneFuelBase.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private float fuelAccumulator;

    public EntityPlaneFuelBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public abstract int getFuelCapacity();

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.fuelTick();
        }
    }

    protected void fuelTick() {
        if (!this.isStarted()) {
            return;
        }
        this.setFuel(Math.max(this.getFuel() - this.calculateFuelUsage(), 0));
    }

    protected int calculateFuelUsage() {
        float maxUsage = this.getBaseFuelUsage() * this.getFuelMultiplier();
        float idleUsage = Math.max(Math.min(this.getIdleUsageMultiplier(), 1.0f), 0.0f);
        maxUsage = maxUsage * idleUsage + maxUsage * this.getEngineSpeed() * (1.0f - idleUsage);
        this.fuelAccumulator += maxUsage;
        int fuelInt = (int)this.fuelAccumulator;
        this.fuelAccumulator -= (float)fuelInt;
        return fuelInt;
    }

    protected abstract float getBaseFuelUsage();

    protected float getFuelMultiplier() {
        return 1.0f;
    }

    protected float getIdleUsageMultiplier() {
        return 0.1f;
    }

    @Override
    public boolean canEngineBeStarted() {
        if (this.getFuel() <= 0) {
            return false;
        }
        return super.canEngineBeStarted();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FUEL, (Object)0);
        builder.define(FUEL_TYPE, (Object)"");
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setFuel(compound.getInt("Fuel"));
        this.setFuelType(compound.getString("FuelType"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Fuel", this.getFuel());
        Fluid fuel = this.getFuelType();
        compound.putString("FuelType", fuel == null ? "" : BuiltInRegistries.FLUID.getKey((Object)fuel).toString());
    }

    @Nullable
    public Fluid getFuelType() {
        String type = (String)this.entityData.get(FUEL_TYPE);
        if (type.isEmpty()) {
            return null;
        }
        ResourceLocation resourceLocation = ResourceLocation.tryParse((String)type);
        if (resourceLocation == null) {
            return null;
        }
        return (Fluid)BuiltInRegistries.FLUID.get(resourceLocation);
    }

    public void setFuelType(Fluid fluid) {
        this.setFuelType(BuiltInRegistries.FLUID.getKey((Object)fluid).toString());
    }

    public void setFuelType(String fluid) {
        this.entityData.set(FUEL_TYPE, (Object)fluid);
    }

    public int getFuel() {
        return (Integer)this.entityData.get(FUEL);
    }

    public void setFuel(int fuel) {
        this.entityData.set(FUEL, (Object)fuel);
    }

    public boolean isValidFuel(FluidStack fluid) {
        return Main.SERVER_CONFIG.validFuels.stream().anyMatch(fluidTag -> fluidTag.contains(fluid.getFluid()));
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        Fluid fluid = this.getFuelType();
        return new FluidStack(fluid == null ? Fluids.EMPTY : fluid, this.getFuel());
    }

    public int getTankCapacity(int tank) {
        return this.getFuelCapacity();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isValidFuel(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource == null || !this.isValidFuel(resource)) {
            return 0;
        }
        Fluid fluid = this.getFuelType();
        if (fluid != null && this.getFuel() > 0 && !resource.getFluid().equals(fluid)) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getFuelCapacity() - this.getFuel());
        if (action.execute()) {
            int i = this.getFuel() + amount;
            if (i > this.getFuelCapacity()) {
                i = this.getFuelCapacity();
            }
            this.setFuel(i);
            this.setFuelType(resource.getFluid());
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }
}

