/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.PlaneType;
import de.maxhenkel.plane.entity.EntityPlaneSoundBase;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class EntityPlaneBase
extends EntityPlaneSoundBase {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(EntityPlaneBase.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private Component typeName;

    public EntityPlaneBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        Component component;
        ItemStack itemInHand = player.getItemInHand(hand);
        if (player.isCrouching() && itemInHand.is(Items.NAME_TAG) && (component = (Component)itemInHand.get(DataComponents.CUSTOM_NAME)) != null) {
            this.setCustomName(component);
            itemInHand.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public abstract Vec3 getBodyRotationCenter();

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    public PlaneType getPlaneType() {
        return PlaneType.values()[(Integer)this.entityData.get(TYPE)];
    }

    public void setPlaneType(PlaneType type) {
        this.entityData.set(TYPE, (Object)type.ordinal());
    }

    protected Component getTypeName() {
        if (this.typeName == null) {
            this.typeName = Component.translatable((String)(this.getType().getDescriptionId() + "." + this.getPlaneType().getTypeName()));
        }
        return this.typeName;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Type", this.getPlaneType().getTypeName());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setPlaneType(PlaneType.fromTypeName(compound.getString("Type")));
    }
}

