/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.plane.entity;

import de.maxhenkel.plane.Main;
import de.maxhenkel.plane.entity.EntityPlaneBase;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;

public class EntityBushPlane
extends EntityPlaneBase {
    private static final Vec3 BODY_CENTER = new Vec3(0.0, 0.0, -1.09375);

    public EntityBushPlane(Level world) {
        this((EntityType<?>)((EntityType)Main.BUSH_PLANE_ENTITY_TYPE.get()), world);
    }

    public EntityBushPlane(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public float getPlayerScaleFactor() {
        return 0.8f;
    }

    @Override
    public void openGUI(Player player, boolean outside) {
    }

    @Override
    public int getFuelCapacity() {
        return (Integer)Main.SERVER_CONFIG.bushPlaneFuelCapacity.get();
    }

    @Override
    protected float getBaseFuelUsage() {
        return ((Double)Main.SERVER_CONFIG.bushPlaneBaseFuelUsage.get()).floatValue();
    }

    @Override
    public double getFallSpeed() {
        return 0.08;
    }

    @Override
    public Vec3[] getPlayerOffsets() {
        return new Vec3[]{new Vec3(0.0, 0.0, 0.5)};
    }

    @Override
    public ResourceKey<LootTable> getLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"plane", (String)("entities/bush_plane_" + this.getPlaneType().getTypeName())));
    }

    @Override
    public Vec3 getBodyRotationCenter() {
        return BODY_CENTER;
    }
}

