/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.search;

import dev.emi.emi.search.ModQuery;
import dev.emi.emi.search.NameQuery;
import dev.emi.emi.search.Query;
import dev.emi.emi.search.RegexModQuery;
import dev.emi.emi.search.RegexNameQuery;
import dev.emi.emi.search.RegexTagQuery;
import dev.emi.emi.search.RegexTooltipQuery;
import dev.emi.emi.search.TagQuery;
import dev.emi.emi.search.TooltipQuery;
import java.util.function.Function;
import net.minecraft.network.chat.Style;

public enum QueryType {
    DEFAULT("", 0xFFFFFF, 0xCC3737, 0xFF5555, 16558421, NameQuery::new, RegexNameQuery::new),
    MOD("@", 0x5555FF, 0x5555FF, 10181851, 0xF22BF2, ModQuery::new, RegexModQuery::new),
    TOOLTIP("$", 0xFFFF55, 0xFFFF55, 12448902, 16039302, TooltipQuery::new, RegexTooltipQuery::new),
    TAG("#", 0x55FF55, 0x55FF55, 4319950, 39146, TagQuery::new, RegexTagQuery::new);

    public final String prefix;
    public final Style color;
    public final Style slashColor;
    public final Style regexColor;
    public final Style escapeColor;
    public final Function<String, Query> queryConstructor;
    public final Function<String, Query> regexQueryConstructor;

    private QueryType(String prefix, int color, int slashColor, int regexColor, int escapeColor, Function<String, Query> queryConstructor, Function<String, Query> regexQueryConstructor) {
        this.prefix = prefix;
        this.color = Style.EMPTY.withColor(color);
        this.slashColor = Style.EMPTY.withColor(slashColor);
        this.regexColor = Style.EMPTY.withColor(regexColor);
        this.escapeColor = Style.EMPTY.withColor(escapeColor);
        this.queryConstructor = queryConstructor;
        this.regexQueryConstructor = regexQueryConstructor;
    }

    public static QueryType fromString(String s) {
        for (int i = QueryType.values().length - 1; i >= 0; --i) {
            QueryType type = QueryType.values()[i];
            if (!s.startsWith(type.prefix)) continue;
            return type;
        }
        return null;
    }
}

