/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dan200.computercraft.core.util.Nullability;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NBTUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NBTUtil.class);
    @VisibleForTesting
    static final BaseEncoding ENCODING = BaseEncoding.base16().lowerCase();

    private NBTUtil() {
    }

    public static <T> @Nullable T decodeFrom(Codec<T> codec, HolderLookup.Provider registries, CompoundTag tag, String key) {
        Tag childTag = tag.get(key);
        return childTag == null ? null : codec.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)childTag).resultOrPartial(e -> LOG.warn("Failed to parse NBT: {}", e)).orElse(null);
    }

    public static <T> void encodeTo(Codec<T> codec, HolderLookup.Provider registries, CompoundTag destination, String key, @Nullable T value) {
        if (value == null) {
            return;
        }
        codec.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), value).resultOrPartial(e -> LOG.warn("Failed to save NBT: {}", e)).ifPresent(x -> destination.put(key, x));
    }

    public static @Nullable Object toLua(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        return switch (tag.getId()) {
            case 1, 2, 3, 4 -> ((NumericTag)tag).getAsLong();
            case 5, 6 -> ((NumericTag)tag).getAsDouble();
            case 8 -> tag.getAsString();
            case 10 -> {
                CompoundTag compound = (CompoundTag)tag;
                HashMap<String, Object> map = new HashMap<String, Object>(compound.size());
                for (String key : compound.getAllKeys()) {
                    Object value = NBTUtil.toLua(compound.get(key));
                    if (value == null) continue;
                    map.put(key, value);
                }
                yield map;
            }
            case 9 -> ((ListTag)tag).stream().map(NBTUtil::toLua).toList();
            case 7 -> {
                byte[] array = ((ByteArrayTag)tag).getAsByteArray();
                ArrayList<Byte> map = new ArrayList<Byte>(array.length);
                for (byte b : array) {
                    map.add(b);
                }
                yield map;
            }
            case 11 -> Arrays.stream(((IntArrayTag)tag).getAsIntArray()).boxed().toList();
            case 12 -> Arrays.stream(((LongArrayTag)tag).getAsLongArray()).boxed().toList();
            default -> null;
        };
    }

    public static @Nullable String getNBTHash(@Nullable Tag tag) {
        if (tag == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            DataOutputStream output = new DataOutputStream(new DigestOutputStream(digest));
            NBTUtil.writeNamedTag(output, "", tag);
            byte[] hash = digest.digest();
            return ENCODING.encode(hash);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOG.error("Cannot hash NBT", (Throwable)e);
            return null;
        }
    }

    private static void writeNamedTag(DataOutput output, String name, Tag tag) throws IOException {
        output.writeByte(tag.getId());
        if (tag.getId() == 0) {
            return;
        }
        output.writeUTF(name);
        NBTUtil.writeTag(output, tag);
    }

    private static void writeTag(DataOutput output, Tag tag) throws IOException {
        if (tag instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)tag;
            Object[] keys = compound.getAllKeys().toArray(new String[0]);
            Arrays.sort(keys);
            for (Object key : keys) {
                NBTUtil.writeNamedTag(output, (String)key, Nullability.assertNonNull(compound.get((String)key)));
            }
            output.writeByte(0);
        } else if (tag instanceof ListTag) {
            ListTag list = (ListTag)tag;
            output.writeByte(list.isEmpty() ? 0 : (int)list.get(0).getId());
            output.writeInt(list.size());
            for (Tag value : list) {
                NBTUtil.writeTag(output, value);
            }
        } else {
            tag.write(output);
        }
    }

    @VisibleForTesting
    static final class DigestOutputStream
    extends OutputStream {
        private final MessageDigest digest;

        DigestOutputStream(MessageDigest digest) {
            this.digest = digest;
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        public void write(int b) {
            this.digest.update((byte)b);
        }
    }
}

