/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public final class ClientMonitor {
    private final MonitorBlockEntity origin;
    private @Nullable NetworkedTerminal terminal;
    private boolean terminalChanged;
    private @Nullable RenderState state;

    public ClientMonitor(MonitorBlockEntity origin) {
        this.origin = origin;
    }

    public MonitorBlockEntity getOrigin() {
        return this.origin;
    }

    public <T extends RenderState> T getRenderState(Supplier<T> create) {
        RenderState state = this.state;
        return (T)(state != null ? state : (this.state = (RenderState)create.get()));
    }

    void destroy() {
        if (this.state != null) {
            this.state.close();
        }
        this.state = null;
    }

    public boolean pollTerminalChanged() {
        boolean changed = this.terminalChanged;
        this.terminalChanged = false;
        return changed;
    }

    public @Nullable Terminal getTerminal() {
        return this.terminal;
    }

    void read(@Nullable TerminalState state) {
        if (state != null) {
            if (this.terminal == null) {
                this.terminal = state.create();
            } else {
                state.apply(this.terminal);
            }
            this.terminalChanged = true;
        } else if (this.terminal != null) {
            this.terminal = null;
            this.terminalChanged = true;
        }
    }

    public static interface RenderState
    extends AutoCloseable {
        @Override
        public void close();
    }
}

