/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.container;

import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public interface BasicContainer
extends Container {
    public List<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (ItemStack stack : this.getItems()) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack getItem(int slot) {
        List<ItemStack> contents = this.getItems();
        return slot >= 0 && slot < contents.size() ? contents.get(slot) : ItemStack.EMPTY;
    }

    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public ItemStack removeItem(int slot, int count) {
        return ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
    }

    default public void setItem(int slot, ItemStack itemStack) {
        this.getItems().set(slot, itemStack);
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    public static void defaultSetItems(List<ItemStack> inventory, List<ItemStack> items) {
        int i;
        for (i = 0; i < items.size(); ++i) {
            inventory.set(i, items.get(i));
        }
        while (i < inventory.size()) {
            inventory.set(i, ItemStack.EMPTY);
            ++i;
        }
    }
}

