/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import java.util.EnumSet;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public final class MonitorHighlightRenderer {
    private MonitorHighlightRenderer() {
    }

    public static boolean drawHighlight(PoseStack transformStack, MultiBufferSource bufferSource, Camera camera, BlockHitResult hit) {
        BlockPos pos;
        if (camera.getEntity().isCrouching()) {
            return false;
        }
        Level world = camera.getEntity().getCommandSenderWorld();
        BlockEntity tile = world.getBlockEntity(pos = hit.getBlockPos());
        if (!(tile instanceof MonitorBlockEntity)) {
            return false;
        }
        MonitorBlockEntity monitor = (MonitorBlockEntity)tile;
        EnumSet<Direction> faces = EnumSet.allOf(Direction.class);
        Direction front = monitor.getFront();
        faces.remove(front);
        if (monitor.getXIndex() != 0) {
            faces.remove(monitor.getRight().getOpposite());
        }
        if (monitor.getXIndex() != monitor.getWidth() - 1) {
            faces.remove(monitor.getRight());
        }
        if (monitor.getYIndex() != 0) {
            faces.remove(monitor.getDown().getOpposite());
        }
        if (monitor.getYIndex() != monitor.getHeight() - 1) {
            faces.remove(monitor.getDown());
        }
        Vec3 cameraPos = camera.getPosition();
        transformStack.pushPose();
        transformStack.translate((double)pos.getX() - cameraPos.x(), (double)pos.getY() - cameraPos.y(), (double)pos.getZ() - cameraPos.z());
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        Matrix4f transform = transformStack.last().pose();
        PoseStack.Pose normal = transformStack.last();
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.WEST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 0.0f, Direction.UP);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.WEST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 1.0f, Direction.UP);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.EAST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 0.0f, 0.0f, Direction.UP);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.EAST)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 0.0f, 1.0f, Direction.UP);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 0.0f, Direction.EAST);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 1.0f, Direction.EAST);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 1.0f, 0.0f, Direction.EAST);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 1.0f, 1.0f, Direction.EAST);
        }
        if (faces.contains(Direction.WEST) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 0.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.EAST) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 0.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.WEST) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 0.0f, 1.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.EAST) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, normal, 1.0f, 1.0f, 0.0f, Direction.SOUTH);
        }
        transformStack.popPose();
        return true;
    }

    private static void line(VertexConsumer buffer, Matrix4f transform, PoseStack.Pose normal, float x, float y, float z, Direction direction) {
        buffer.addVertex(transform, x, y, z).setColor(0.0f, 0.0f, 0.0f, 0.4f).setNormal(normal, (float)direction.getStepX(), (float)direction.getStepY(), (float)direction.getStepZ());
        buffer.addVertex(transform, x + (float)direction.getStepX(), y + (float)direction.getStepY(), z + (float)direction.getStepZ()).setColor(0.0f, 0.0f, 0.0f, 0.4f).setNormal(normal, (float)direction.getStepX(), (float)direction.getStepY(), (float)direction.getStepZ());
    }
}

