/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.sort;

import io.github.jamalam360.sort_it_out.preference.UserPreferences;
import io.github.jamalam360.sort_it_out.sort.ContainerSorter;
import io.github.jamalam360.sort_it_out.sort.SortableContainer;
import java.util.Comparator;
import net.minecraft.world.item.ItemStack;

public class QuickSortContainerSorter
implements ContainerSorter {
    public static final QuickSortContainerSorter INSTANCE = new QuickSortContainerSorter();

    private QuickSortContainerSorter() {
    }

    @Override
    public void sort(SortableContainer container, int startIndex, int containerSize, UserPreferences preferences) {
        this.mergeStacks(container, startIndex, containerSize);
        QuickSortContainerSorter.quickSort(container, startIndex, startIndex + containerSize - 1, preferences.createComparator());
    }

    private static void quickSort(SortableContainer container, int low, int high, Comparator<ItemStack> comparator) {
        if (low < high) {
            int partition = QuickSortContainerSorter.partition(container, low, high, comparator);
            QuickSortContainerSorter.quickSort(container, low, partition - 1, comparator);
            QuickSortContainerSorter.quickSort(container, partition + 1, high, comparator);
        }
    }

    private static int partition(SortableContainer container, int low, int high, Comparator<ItemStack> comparator) {
        ItemStack pivot = container.getItem(high);
        int i = low - 1;
        for (int j = low; j <= high - 1; ++j) {
            if (comparator.compare(container.getItem(j), pivot) >= 0) continue;
            container.swapStacks(++i, j);
        }
        container.swapStacks(i + 1, high);
        return i + 1;
    }
}

