/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.sort_it_out.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.networking.NetworkManager;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.sort_it_out.command.Arguments;
import io.github.jamalam360.sort_it_out.command.CommandFeedback;
import io.github.jamalam360.sort_it_out.network.BidirectionalUserPreferencesUpdatePacket;
import io.github.jamalam360.sort_it_out.preference.ServerUserPreferences;
import io.github.jamalam360.sort_it_out.preference.UserPreferences;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SortItOutCommands {
    public static void register() {
        CommandRegistrationEvent.EVENT.register(SortItOutCommands::registerCommands);
    }

    private static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext register, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sortitout").then(Commands.literal((String)"help").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.translatable((CommandContext<CommandSourceStack>)ctx, "text.sort_it_out.command.help", new Object[0]), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"preferences").then(((LiteralArgumentBuilder)Commands.literal((String)"invertSorting").executes(SortItOutCommands::echoInvertSorting)).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(SortItOutCommands::setInvertSorting)))).then(((LiteralArgumentBuilder)Commands.literal((String)"comparators").executes(SortItOutCommands::echoComparators)).then(((RequiredArgumentBuilder)Arguments.sortingComparator("comparator0").executes(ctx -> SortItOutCommands.setComparators((CommandContext<CommandSourceStack>)ctx, 1))).then(((RequiredArgumentBuilder)Arguments.sortingComparator("comparator1").executes(ctx -> SortItOutCommands.setComparators((CommandContext<CommandSourceStack>)ctx, 2))).then(((RequiredArgumentBuilder)Arguments.sortingComparator("comparator2").executes(ctx -> SortItOutCommands.setComparators((CommandContext<CommandSourceStack>)ctx, 3))).then(Arguments.sortingComparator("comparator3").executes(ctx -> SortItOutCommands.setComparators((CommandContext<CommandSourceStack>)ctx, 4)))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"slotSortingTrigger").executes(SortItOutCommands::echoSlotSortingTrigger)).then(Arguments.slotSortingTrigger("value").executes(SortItOutCommands::setSlotSortingTrigger)))));
    }

    private static void modifyConfig(CommandContext<CommandSourceStack> ctx, Consumer<UserPreferences> modifier) {
        ConfigManager<UserPreferences> manager = ServerUserPreferences.INSTANCE.getPlayerConfigManager((Player)((CommandSourceStack)ctx.getSource()).getPlayer());
        modifier.accept((UserPreferences)manager.get());
        manager.save();
        if (((CommandSourceStack)ctx.getSource()).getPlayer() != null && NetworkManager.canPlayerReceive((ServerPlayer)((CommandSourceStack)ctx.getSource()).getPlayer(), BidirectionalUserPreferencesUpdatePacket.S2C.TYPE)) {
            NetworkManager.sendToPlayer((ServerPlayer)((CommandSourceStack)ctx.getSource()).getPlayer(), (CustomPacketPayload)new BidirectionalUserPreferencesUpdatePacket.S2C((UserPreferences)manager.get()));
        }
    }

    private static int echoInvertSorting(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.formatInvertSorting(ctx), false);
        return 1;
    }

    private static int setInvertSorting(CommandContext<CommandSourceStack> ctx) {
        SortItOutCommands.modifyConfig(ctx, prefs -> {
            prefs.invertSorting = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
        });
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.formatInvertSorting(ctx), false);
        return 1;
    }

    private static int echoComparators(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.formatComparators(ctx), false);
        return 1;
    }

    private static int setComparators(CommandContext<CommandSourceStack> ctx, int cardinality) {
        ArrayList<UserPreferences.SortingComparator> comparators = new ArrayList<UserPreferences.SortingComparator>();
        for (int i = 0; i < cardinality; ++i) {
            comparators.add(Arguments.getSortingComparator(ctx, "comparator" + i));
        }
        SortItOutCommands.modifyConfig(ctx, prefs -> {
            prefs.comparators = comparators;
        });
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.formatComparators(ctx), false);
        return 1;
    }

    private static int echoSlotSortingTrigger(CommandContext<CommandSourceStack> ctx) {
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.formatSlotSortingTrigger(ctx), false);
        return 1;
    }

    private static int setSlotSortingTrigger(CommandContext<CommandSourceStack> ctx) {
        UserPreferences.SlotSortingTrigger trigger = Arguments.getSlotSortingTrigger(ctx, "value");
        if (trigger == null) {
            return 0;
        }
        SortItOutCommands.modifyConfig(ctx, prefs -> {
            prefs.slotSortingTrigger = trigger;
        });
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> CommandFeedback.formatSlotSortingTrigger(ctx), false);
        return 1;
    }
}

