/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.foundation.item.ItemHandlerWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class PackagePortAutomationInventoryWrapper
extends ItemHandlerWrapper {
    private PackagePortBlockEntity ppbe;
    private boolean access;

    public PackagePortAutomationInventoryWrapper(IItemHandlerModifiable wrapped, PackagePortBlockEntity ppbe) {
        super(wrapped);
        this.ppbe = ppbe;
        this.access = false;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.access) {
            return super.extractItem(slot, amount, simulate);
        }
        this.access = true;
        ItemStack extract = ItemHelper.extract((IItemHandler)this, stack -> {
            if (!PackageItem.isPackage(stack)) {
                return false;
            }
            String filterString = this.ppbe.getFilterString();
            return filterString != null && PackageItem.matchAddress(stack, filterString);
        }, simulate);
        this.access = false;
        return extract;
    }

    @Override
    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!PackageItem.isPackage(stack)) {
            return stack;
        }
        String filterString = this.ppbe.getFilterString();
        if (filterString != null && PackageItem.matchAddress(stack, filterString)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }
}

