/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation;

import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.compat.computercraft.implementation.peripherals.DisplayLinkPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SequencedGearshiftPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedControllerPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.SpeedGaugePeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StationPeripheral;
import com.simibubi.create.compat.computercraft.implementation.peripherals.StressGaugePeripheral;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    IPeripheral peripheral;
    Supplier<IPeripheral> peripheralSupplier;
    SmartBlockEntity be;

    public ComputerBehaviour(SmartBlockEntity be) {
        super(be);
        this.peripheralSupplier = ComputerBehaviour.getPeripheralFor(be);
        this.be = be;
    }

    public static Supplier<IPeripheral> getPeripheralFor(SmartBlockEntity be) {
        if (be instanceof SpeedControllerBlockEntity) {
            SpeedControllerBlockEntity scbe = (SpeedControllerBlockEntity)be;
            return () -> new SpeedControllerPeripheral(scbe, scbe.targetSpeed);
        }
        if (be instanceof DisplayLinkBlockEntity) {
            DisplayLinkBlockEntity dlbe = (DisplayLinkBlockEntity)be;
            return () -> new DisplayLinkPeripheral(dlbe);
        }
        if (be instanceof SequencedGearshiftBlockEntity) {
            SequencedGearshiftBlockEntity sgbe = (SequencedGearshiftBlockEntity)be;
            return () -> new SequencedGearshiftPeripheral(sgbe);
        }
        if (be instanceof SpeedGaugeBlockEntity) {
            SpeedGaugeBlockEntity sgbe = (SpeedGaugeBlockEntity)be;
            return () -> new SpeedGaugePeripheral(sgbe);
        }
        if (be instanceof StressGaugeBlockEntity) {
            StressGaugeBlockEntity sgbe = (StressGaugeBlockEntity)be;
            return () -> new StressGaugePeripheral(sgbe);
        }
        if (be instanceof StationBlockEntity) {
            StationBlockEntity sbe = (StationBlockEntity)be;
            return () -> new StationPeripheral(sbe);
        }
        throw new IllegalArgumentException("No peripheral available for " + String.valueOf(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)be.getType())));
    }

    @Override
    public IPeripheral getPeripheralCapability() {
        if (this.peripheral == null) {
            this.peripheral = this.peripheralSupplier.get();
        }
        return this.peripheral;
    }

    @Override
    public void removePeripheral() {
        if (this.peripheral != null) {
            this.getWorld().invalidateCapabilities(this.be.getBlockPos());
        }
    }
}

