/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class AutoCommand {
    static final String VALUE = "value";
    final Field field;
    final Class<?> type;
    final String modid;
    final boolean isList;
    final boolean isNumber;

    public AutoCommand(Field field, String modid) {
        this.field = field;
        this.modid = modid;
        this.type = MidnightConfig.getUnderlyingType(field);
        this.isList = field.getType() == List.class;
        this.isNumber = this.type == Integer.TYPE || this.type == Double.TYPE || this.type == Float.TYPE;
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)field.getName()).executes(this::getValue);
        if (this.type.isEnum()) {
            for (Object enumValue : field.getType().getEnumConstants()) {
                command = (LiteralArgumentBuilder)command.then(Commands.literal((String)enumValue.toString()).executes(ctx -> this.setValue((CommandSourceStack)ctx.getSource(), enumValue, "")));
            }
        } else if (this.isList) {
            for (String action : List.of("add", "remove")) {
                command = (LiteralArgumentBuilder)command.then(Commands.literal((String)action).then(Commands.argument((String)VALUE, this.getArgType()).executes(ctx -> this.setValueFromArg((CommandContext<CommandSourceStack>)ctx, action))));
            }
        } else {
            command = (LiteralArgumentBuilder)command.then(Commands.argument((String)VALUE, this.getArgType()).executes(ctx -> this.setValueFromArg((CommandContext<CommandSourceStack>)ctx, "")));
        }
        PlatformFunctions.registerCommand((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"midnightconfig").requires(source -> source.hasPermission(2))).then(Commands.literal((String)modid).then((ArgumentBuilder)command))));
    }

    public ArgumentType<?> getArgType() {
        if (this.isNumber) {
            MidnightConfig.Entry entry = this.field.getAnnotation(MidnightConfig.Entry.class);
            if (this.type == Integer.TYPE) {
                return IntegerArgumentType.integer((int)((int)entry.min()), (int)((int)entry.max()));
            }
            if (this.type == Double.TYPE) {
                return DoubleArgumentType.doubleArg((double)entry.min(), (double)entry.max());
            }
            if (this.type == Float.TYPE) {
                return FloatArgumentType.floatArg((float)((float)entry.min()), (float)((float)entry.max()));
            }
        } else if (this.type == Boolean.TYPE) {
            return BoolArgumentType.bool();
        }
        return StringArgumentType.string();
    }

    public int setValueFromArg(CommandContext<CommandSourceStack> context, String action) {
        if (this.isNumber) {
            if (this.type == Integer.TYPE) {
                return this.setValue((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger(context, (String)VALUE), action);
            }
            if (this.type == Double.TYPE) {
                return this.setValue((CommandSourceStack)context.getSource(), DoubleArgumentType.getDouble(context, (String)VALUE), action);
            }
            if (this.type == Float.TYPE) {
                return this.setValue((CommandSourceStack)context.getSource(), Float.valueOf(FloatArgumentType.getFloat(context, (String)VALUE)), action);
            }
        } else if (this.type == Boolean.TYPE) {
            return this.setValue((CommandSourceStack)context.getSource(), BoolArgumentType.getBool(context, (String)VALUE), action);
        }
        return this.setValue((CommandSourceStack)context.getSource(), StringArgumentType.getString(context, (String)VALUE), action);
    }

    private int setValue(CommandSourceStack source, Object value, String action) {
        boolean add = Objects.equals(action, "add");
        try {
            if (!this.isList) {
                this.field.set(null, value);
            } else {
                List list = (List)this.field.get(null);
                if (add) {
                    list.add(value);
                } else {
                    if (!list.contains(value)) {
                        throw new IllegalArgumentException("List does not contain this string!");
                    }
                    list.remove(value);
                }
            }
            MidnightConfig.write(this.modid);
        }
        catch (Exception e) {
            if (!this.isList) {
                source.sendFailure((Component)Component.literal((String)("Could not set " + this.field.getName() + " to value " + String.valueOf(value) + ": " + String.valueOf(e))));
            } else {
                source.sendFailure((Component)Component.literal((String)((add ? "Could not add " + String.valueOf(value) + " to " : "Could not remove " + String.valueOf(value) + " from ") + this.field.getName() + ": " + String.valueOf(e))));
            }
            return 0;
        }
        if (!this.isList) {
            source.sendSuccess(() -> Component.literal((String)("Successfully set " + this.field.getName() + " to " + String.valueOf(value))), true);
        } else {
            source.sendSuccess(() -> Component.literal((String)((add ? "Successfully added " + String.valueOf(value) + " to " : "Successfully removed " + String.valueOf(value) + " from ") + this.field.getName())), true);
        }
        return 1;
    }

    private int getValue(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> {
            try {
                return Component.literal((String)("The value of " + this.field.getName() + " is " + String.valueOf(this.field.get(null))));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, true);
        return 0;
    }
}

