/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.core.screen;

import eu.midnightdust.core.MidnightLib;
import eu.midnightdust.lib.config.MidnightConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MidnightConfigOverviewScreen
extends Screen {
    private final Screen parent;
    private MidnightConfig.MidnightConfigListWidget list;

    public MidnightConfigOverviewScreen(Screen parent) {
        super((Component)Component.translatable((String)"midnightlib.overview.title"));
        this.parent = parent;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> Objects.requireNonNull(this.minecraft).setScreen(this.parent)).bounds(this.width / 2 - 100, this.height - 26, 200, 20).build());
        this.list = new MidnightConfig.MidnightConfigListWidget(this.minecraft, this.width, this.height - 57, 24, 25);
        this.addWidget((GuiEventListener)this.list);
        ArrayList<String> sortedMods = new ArrayList<String>(MidnightConfig.configClass.keySet());
        Collections.sort(sortedMods);
        sortedMods.forEach(modid -> {
            if (!MidnightLib.hiddenMods.contains(modid)) {
                this.list.addButton(List.of(Button.builder((Component)Component.translatable((String)(modid + ".midnightconfig.title")), button -> Objects.requireNonNull(this.minecraft).setScreen(MidnightConfig.getScreen(this, modid))).bounds(this.width / 2 - 125, this.height - 28, 250, 20).build()), null, null);
            }
        });
        super.init();
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.list.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 10, 0xFFFFFF);
    }
}

