/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.platform.NativeImage;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final Minecraft MINECRAFT = Minecraft.getInstance();
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    private NativeImage lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.Quality.lodShading.get();
        switch (lodShading) {
            default: {
                if (MinecraftClientWrapper.MINECRAFT.level != null) {
                    Direction mcDir = McObjectConverter.Convert(lodDirection);
                    return MinecraftClientWrapper.MINECRAFT.level.getShade(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return MINECRAFT.hasSingleplayerServer();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return MINECRAFT.getCurrentServer() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public boolean connectedToReplay() {
        return !MINECRAFT.hasSingleplayerServer() && MINECRAFT.getCurrentServer() == null;
    }

    @Override
    public String getCurrentServerName() {
        if (this.connectedToReplay()) {
            return "REPLAY";
        }
        ServerData server = MINECRAFT.getCurrentServer();
        return server != null ? server.name : "NULL";
    }

    @Override
    public String getCurrentServerIp() {
        if (this.connectedToReplay()) {
            return "";
        }
        ServerData server = MINECRAFT.getCurrentServer();
        return server != null ? server.ip : "NA";
    }

    @Override
    public String getCurrentServerVersion() {
        ServerData server = MINECRAFT.getCurrentServer();
        return server != null ? server.version.getString() : "UNKOWN";
    }

    public LocalPlayer getPlayer() {
        return MinecraftClientWrapper.MINECRAFT.player;
    }

    @Override
    public boolean playerExists() {
        return MinecraftClientWrapper.MINECRAFT.player != null;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.getPlayer().getUUID();
    }

    @Override
    public String getUsername() {
        return MINECRAFT.getUser().getName();
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return new DhBlockPos(0, 0, 0);
        }
        BlockPos playerPos = player.blockPosition();
        return new DhBlockPos(playerPos.getX(), playerPos.getY(), playerPos.getZ());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return new DhChunkPos(0, 0);
        }
        ChunkPos playerPos = player.chunkPosition();
        return new DhChunkPos(playerPos.x, playerPos.z);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        return this.getWrappedClientLevel(false);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel(boolean bypassLevelKeyManager) {
        ClientLevel level = MinecraftClientWrapper.MINECRAFT.level;
        if (level == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapper(level, bypassLevelKeyManager);
    }

    @Override
    public IProfilerWrapper getProfiler() {
        ProfilerFiller profiler = MINECRAFT.getProfiler();
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(profiler);
        } else if (profiler != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = profiler;
        }
        return this.profilerWrapper;
    }

    @Override
    public ArrayList<ILevelWrapper> getAllServerWorlds() {
        ArrayList<ILevelWrapper> worlds = new ArrayList<ILevelWrapper>();
        Iterable serverWorlds = MINECRAFT.getSingleplayerServer().getAllLevels();
        for (ServerLevel world : serverWorlds) {
            worlds.add(ServerLevelWrapper.getWrapper(world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)string), false);
    }

    @Override
    public void sendOverlayMessage(String string) {
        LocalPlayer player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)string), true);
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        CrashReport report = new CrashReport(errorMessage, exception);
        Minecraft.getInstance().delayCrash(report);
    }

    @Override
    public Object getOptionsObject() {
        return MinecraftClientWrapper.MINECRAFT.options;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return MinecraftClientWrapper.MINECRAFT.gameDirectory;
    }

    @Override
    public void executeOnRenderThread(Runnable runnable) {
        MINECRAFT.execute(runnable);
    }

    @Override
    public int getPlayerCount() {
        if (MINECRAFT.getSingleplayerServer() == null) {
            return 1;
        }
        return MINECRAFT.getSingleplayerServer().getPlayerCount();
    }
}

