/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.node.parent;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.node.parent.SimpleStylingNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public final class HoverNode<T, H>
extends SimpleStylingNode {
    private final Action<T, H> action;
    private final T value;

    public HoverNode(TextNode[] children, Action<T, H> action, T value) {
        super(children);
        this.action = action;
        this.value = value;
    }

    @Override
    protected class_2583 style(ParserContext context) {
        if (this.action == Action.TEXT) {
            return class_2583.field_24360.method_10949(new class_2568(this.action.vanillaType(), (Object)((TextNode)this.value).toText(context, true)));
        }
        if (this.action == Action.ENTITY) {
            return class_2583.field_24360.method_10949(new class_2568(this.action.vanillaType(), (Object)((EntityNodeContent)this.value).toVanilla(context)));
        }
        if (this.action == Action.LAZY_ITEM_STACK) {
            class_7225.class_7874 wrapper;
            if (context.contains(ParserContext.Key.WRAPPER_LOOKUP)) {
                wrapper = context.getOrThrow(ParserContext.Key.WRAPPER_LOOKUP);
            } else if (context.contains(PlaceholderContext.KEY)) {
                wrapper = context.getOrThrow(PlaceholderContext.KEY).server().method_30611();
            } else {
                return class_2583.field_24360;
            }
            return class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)((LazyItemStackNodeContent)this.value).toVanilla(wrapper)));
        }
        return class_2583.field_24360.method_10949(new class_2568(this.action.vanillaType(), this.value));
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children) {
        return new HoverNode<T, H>(children, this.action, this.value);
    }

    @Override
    public ParentTextNode copyWith(TextNode[] children, NodeParser parser) {
        if (this.action == Action.TEXT) {
            return new HoverNode<TextNode, class_2561>(children, Action.TEXT, parser.parseNode((TextNode)this.value));
        }
        if (this.action == Action.ENTITY && ((EntityNodeContent)this.value).name != null) {
            EntityNodeContent val = (EntityNodeContent)this.value;
            return new HoverNode<EntityNodeContent, class_2568.class_5248>(children, Action.ENTITY, new EntityNodeContent(val.entityType, val.uuid, parser.parseNode(val.name)));
        }
        return this.copyWith(children);
    }

    public Action<T, H> action() {
        return this.action;
    }

    public T value() {
        return this.value;
    }

    @Override
    public String toString() {
        return "HoverNode{value=" + String.valueOf(this.value) + ", children=" + Arrays.toString(this.children) + "}";
    }

    @Override
    public boolean isDynamicNoChildren() {
        return this.action == Action.TEXT && ((TextNode)this.value).isDynamic() || this.action == Action.ENTITY && ((EntityNodeContent)this.value).name.isDynamic() || this.action == Action.LAZY_ITEM_STACK;
    }

    public record Action<T, H>(class_2568.class_5247<H> vanillaType) {
        public static final Action<EntityNodeContent, class_2568.class_5248> ENTITY = new Action(class_2568.class_5247.field_24344);
        public static final Action<TextNode, class_2561> TEXT = new Action(class_2568.class_5247.field_24342);
        public static final Action<class_2568.class_5249, class_2568.class_5249> ITEM_STACK = new Action(class_2568.class_5247.field_24343);
        public static final Action<LazyItemStackNodeContent, class_2568.class_5249> LAZY_ITEM_STACK = new Action(class_2568.class_5247.field_24343);
    }

    public record EntityNodeContent(class_1299<?> entityType, UUID uuid, @Nullable TextNode name) {
        public class_2568.class_5248 toVanilla(ParserContext context) {
            return new class_2568.class_5248(this.entityType, this.uuid, this.name != null ? this.name.toText(context, true) : null);
        }
    }

    public record LazyItemStackNodeContent<T>(class_2960 identifier, int count, DynamicOps<T> ops, T componentMap) {
        public class_2568.class_5249 toVanilla(class_7225.class_7874 lookup) {
            class_1799 stack = new class_1799((class_6880)lookup.method_46762(class_7924.field_41197).method_46747(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)this.identifier)));
            stack.method_7939(this.count);
            stack.method_59692((class_9326)((Pair)class_9326.field_49589.decode((DynamicOps)lookup.method_57093(this.ops), this.componentMap).getOrThrow()).getFirst());
            return new class_2568.class_5249(stack);
        }
    }
}

