/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class NotUglyEditBox
extends class_339
implements class_4068 {
    private final class_327 font;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    @Nullable
    public Consumer<String> responder;
    private String value = "";
    private int maxLength = 32;
    @Nullable
    private class_8666 background = class_342.field_45914;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, class_5481> formatter = (string, integer) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);
    @Nullable
    private class_2561 hint;
    private long focusedTime = class_156.method_658();
    private boolean isMouseOverCross;

    public NotUglyEditBox(class_327 font, int i, int j, int k, int l, class_2561 component) {
        this(font, i, j, k, l, null, component);
    }

    public NotUglyEditBox(class_327 font, int i, int j, int k, int l, @Nullable NotUglyEditBox editBox, class_2561 component) {
        super(i, j, k, l, component);
        this.font = font;
        if (editBox != null) {
            this.setValue(editBox.getValue());
        }
    }

    public void setFormatter(BiFunction<String, Integer, class_5481> biFunction) {
        this.formatter = biFunction;
    }

    protected class_5250 method_25360() {
        class_2561 component = this.method_25369();
        String value = this.isMouseOverCross ? "" : this.value;
        return class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{component, value});
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (!this.filter.test(string)) {
            return;
        }
        this.value = string.length() > this.maxLength ? string.substring(0, this.maxLength) : string;
        this.moveCursorToEnd();
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(string);
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> predicate) {
        this.filter = predicate;
    }

    public void insertText(String string) {
        String string3;
        String string2;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (string2 = class_3544.method_57180((String)string)).length())) {
            string2 = string2.substring(0, k);
            l = k;
        }
        if (!this.filter.test(string3 = new StringBuilder(this.value).replace(i, j, string2).toString())) {
            return;
        }
        this.value = string3;
        this.setCursorPosition(i + l);
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(this.value);
    }

    private void onValueChange(String string) {
        if (this.responder != null) {
            this.responder.accept(string);
        }
    }

    private void deleteText(int i) {
        if (class_437.method_25441()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int i) {
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        this.deleteChars(this.getWordPosition(i) - this.cursorPos);
    }

    public void deleteChars(int i) {
        int l;
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        int j = this.getCursorPos(i);
        int k = Math.min(j, this.cursorPos);
        if (k == (l = Math.max(j, this.cursorPos))) {
            return;
        }
        String string = new StringBuilder(this.value).delete(k, l).toString();
        if (!this.filter.test(string)) {
            return;
        }
        this.value = string;
        this.moveCursorTo(k);
    }

    public int getWordPosition(int i) {
        return this.getWordPosition(i, this.getCursorPosition());
    }

    private int getWordPosition(int i, int j) {
        return this.getWordPosition(i, j, true);
    }

    private int getWordPosition(int i, int j, boolean bl) {
        int k = j;
        boolean bl2 = i < 0;
        int l = Math.abs(i);
        for (int m = 0; m < l; ++m) {
            if (bl2) {
                while (bl && k > 0 && this.value.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.value.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int n = this.value.length();
            if ((k = this.value.indexOf(32, k)) == -1) {
                k = n;
                continue;
            }
            while (bl && k < n && this.value.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void moveCursor(int i) {
        this.moveCursorTo(this.getCursorPos(i));
    }

    private int getCursorPos(int i) {
        return class_156.method_27761((String)this.value, (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int i) {
        this.setCursorPosition(i);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean method_25404(int i, int j, int k) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = class_437.method_25442();
        if (class_437.method_25439((int)i)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (class_437.method_25438((int)i)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            return true;
        }
        if (class_437.method_25437((int)i)) {
            if (this.isEditable) {
                this.insertText(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)i)) {
            class_310.method_1551().field_1774.method_1455(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (i) {
            case 263: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = class_437.method_25442();
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: {
                this.moveCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char c, int i) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (class_3544.method_57175((char)c)) {
            if (this.isEditable) {
                this.insertText(Character.toString(c));
            }
            return true;
        }
        return false;
    }

    public void method_25348(double x, double y) {
        if (this.isMouseOverCross) {
            this.setValue("");
            super.method_25354(class_310.method_1551().method_1483());
            return;
        }
        int i = class_3532.method_15357((double)x) - this.method_46426() - this.paddingLeft;
        String string = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.method_27523(string, i).length() + this.displayPos);
    }

    public void method_25354(class_1144 soundManager) {
    }

    public void method_48579(class_332 guiGraphics, int i, int j, float f) {
        this.isMouseOverCross = false;
        if (!this.isVisible()) {
            return;
        }
        if (this.background != null) {
            class_2960 resourceLocation = this.background.method_52729(this.method_37303(), this.method_25370());
            guiGraphics.method_52706(class_1921::method_62277, resourceLocation, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        } else {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -1073741824);
        }
        if (this.isEditable && !this.value.isEmpty()) {
            this.isMouseOverCross = this.field_22762 && i > this.field_22758 - this.paddingRight + 4;
            int c = this.isMouseOverCross ? this.textColor : this.textColorUneditable;
            guiGraphics.method_25303(this.font, "\u00d7", this.method_46426() + this.field_22758 - 10, this.method_46427() + this.paddingTop + 1, c);
        }
        int k = this.isEditable ? this.textColor : this.textColorUneditable;
        int l = this.cursorPos - this.displayPos;
        int m = this.highlightPos - this.displayPos;
        String string = this.font.method_27523(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean bl = l >= 0 && l <= string.length();
        boolean bl2 = this.method_25370() && (class_156.method_658() - this.focusedTime) / 300L % 2L == 0L && bl;
        int n = this.method_46426() + this.paddingLeft;
        int o = this.method_46427() + this.paddingTop;
        int p = n;
        if (m > string.length()) {
            m = string.length();
        }
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, l) : string;
            p = guiGraphics.method_35720(this.font, this.formatter.apply(string2, this.displayPos), p, o, k);
        }
        boolean bl3 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int q = p;
        if (!bl) {
            q = l > 0 ? n + this.field_22758 : n;
        } else if (bl3) {
            --q;
            --p;
        }
        if (!string.isEmpty() && bl && l < string.length()) {
            guiGraphics.method_35720(this.font, this.formatter.apply(string.substring(l), this.cursorPos), p, o, k);
        }
        if (this.hint != null && string.isEmpty() && !this.method_25370()) {
            guiGraphics.method_27535(this.font, this.hint, p, o, 0x808080);
        }
        if (!bl3 && this.suggestion != null) {
            guiGraphics.method_25303(this.font, this.suggestion, q - 1, o, -8355712);
        }
        if (bl2) {
            class_1921 class_19212 = class_1921.method_51785();
            Objects.requireNonNull(this.font);
            guiGraphics.method_51739(class_19212, q, o - 1, q + 1, o + 1 + 9, -3092272);
        }
        if (m != l) {
            int r = n + this.font.method_1727(string.substring(0, m));
            Objects.requireNonNull(this.font);
            this.renderHighlight(guiGraphics, q, o - 1, r - 1, o + 1 + 9);
        }
    }

    private void renderHighlight(class_332 guiGraphics, int i, int j, int k, int l) {
        int m;
        if (i < k) {
            m = i;
            i = k;
            k = m;
        }
        if (j < l) {
            m = j;
            j = l;
            l = m;
        }
        if (k > this.method_46426() + this.field_22758) {
            k = this.method_46426() + this.field_22758;
        }
        if (i > this.method_46426() + this.field_22758) {
            i = this.method_46426() + this.field_22758;
        }
        guiGraphics.method_51739(class_1921.method_51786(), i, j, k, l, -16776961);
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int i) {
        this.maxLength = i;
        if (this.value.length() > i) {
            this.value = this.value.substring(0, i);
            this.onValueChange(this.value);
        }
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setCursorPosition(int i) {
        this.cursorPos = class_3532.method_15340((int)i, (int)0, (int)this.value.length());
    }

    @Nullable
    public class_8666 getBackground() {
        return this.background;
    }

    public void setBackground(@Nullable class_8666 background) {
        this.background = background;
    }

    public void setTextColor(int i) {
        this.textColor = i;
    }

    public void setTextColorUneditable(int i) {
        this.textColorUneditable = i;
    }

    @Nullable
    public class_8016 method_48205(class_8023 focusNavigationEvent) {
        if (!this.field_22764 || !this.isEditable) {
            return null;
        }
        return super.method_48205(focusNavigationEvent);
    }

    public boolean method_25405(double d, double e) {
        return this.field_22764 && d >= (double)this.method_46426() && d < (double)(this.method_46426() + this.field_22758) && e >= (double)this.method_46427() && e < (double)(this.method_46427() + this.field_22759);
    }

    public void method_25365(boolean bl) {
        if (!this.canLoseFocus && !bl) {
            return;
        }
        super.method_25365(bl);
        if (bl) {
            this.focusedTime = class_156.method_658();
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public int getInnerWidth() {
        return this.field_22758 - this.paddingLeft - this.paddingRight;
    }

    public void setHighlightPos(int i) {
        int j = this.value.length();
        this.highlightPos = class_3532.method_15340((int)i, (int)0, (int)j);
        if (this.font != null) {
            if (this.displayPos > j) {
                this.displayPos = j;
            }
            int k = this.getInnerWidth();
            String string = this.font.method_27523(this.value.substring(this.displayPos), k);
            int l = string.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.method_27524(this.value, k, true).length();
            }
            if (this.highlightPos > l) {
                this.displayPos += this.highlightPos - l;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = class_3532.method_15340((int)this.displayPos, (int)0, (int)j);
        }
    }

    public void setCanLoseFocus(boolean bl) {
        this.canLoseFocus = bl;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean bl) {
        this.field_22764 = bl;
    }

    public void setSuggestion(@Nullable String string) {
        this.suggestion = string;
    }

    public int getScreenX(int i) {
        if (i > this.value.length()) {
            return this.method_46426();
        }
        return this.method_46426() + this.font.method_1727(this.value.substring(0, i));
    }

    public void method_47399(class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.isMouseOverCross) {
            narrationElementOutput.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.jade.clear_content.usage"));
        }
    }

    public void setHint(class_2561 component) {
        this.hint = component;
    }
}

