/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.WailaConfig;

public class ProfileConfigScreen
extends BaseOptionsScreen {
    private OptionValue<Boolean> enabledEntry;

    public ProfileConfigScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"gui.jade.profile_settings"));
        this.saver = () -> {
            IWailaConfig.get().save();
            class_304.method_1426();
            class_310.method_1551().field_1690.method_1640();
        };
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        int index = Jade.rootConfig().profileIndex;
        Runnable runnable = JadeClient.recoverKeysAction($ -> JadeClient.openConfig.method_1423().equals($.method_1423()));
        this.canceller = () -> {
            if (enabled) {
                Jade.useProfile(index);
            } else {
                Jade.rootConfig().setEnableProfiles(false);
            }
            runnable.run();
        };
    }

    @Override
    public OptionsList createOptions() {
        Objects.requireNonNull(this.field_22787);
        OptionsList options = new OptionsList(this, this.field_22787, this.field_22789 - 120, this.field_22790 - 32, 0, 26, IWailaConfig.get()::save);
        WailaConfig.Root root = Jade.rootConfig();
        options.title("general");
        this.enabledEntry = options.choices("enable_profiles", root::isEnableProfiles, value -> {
            Jade.rootConfig().setEnableProfiles(value);
            this.refresh();
        });
        for (int i = 0; i < JadeClient.profiles.length; ++i) {
            options.add(new ProfileEntry(i));
        }
        options.title("key_binds");
        for (class_304 keyMapping : JadeClient.profiles) {
            options.keybind(keyMapping);
        }
        return options;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.refresh();
    }

    public void refresh() {
        boolean enabled = Jade.rootConfig().isEnableProfiles();
        for (OptionsList.Entry entry : this.options.method_25396()) {
            if (entry == this.enabledEntry) continue;
            entry.setDisabled(!enabled);
            if (!(entry instanceof ProfileEntry)) continue;
            ProfileEntry profileEntry = (ProfileEntry)entry;
            profileEntry.refresh();
        }
    }

    public static class ProfileEntry
    extends OptionButton {
        public static final class_2561 USE = class_2561.method_43471((String)"gui.jade.profile.use");
        public static final class_2561 SAVE = class_2561.method_43471((String)"selectWorld.edit.save");
        private final int index;
        private final class_2561 normalTitle;

        public ProfileEntry(int index) {
            super((class_2561)class_2561.method_43471((String)("config.jade.profile." + index)), class_4185.method_46430((class_2561)USE, $ -> {
                Jade.useProfile(index);
                class_437 patt0$temp = class_310.method_1551().field_1755;
                if (patt0$temp instanceof ProfileConfigScreen) {
                    ProfileConfigScreen screen = (ProfileConfigScreen)patt0$temp;
                    screen.refresh();
                }
            }).method_46437(48, 20).method_46431());
            this.index = index;
            this.normalTitle = this.title;
            this.addWidget((class_339)class_4185.method_46430((class_2561)SAVE, $ -> {
                if (class_437.method_25441()) {
                    Jade.saveProfile(index);
                    return;
                }
                class_310 mc = class_310.method_1551();
                class_437 screen = mc.field_1755;
                mc.method_1507((class_437)new class_410(bl -> {
                    if (bl) {
                        Jade.saveProfile(index);
                    }
                    class_310.method_1551().method_1507(screen);
                }, (class_2561)class_2561.method_43471((String)"gui.jade.save_profile.title"), (class_2561)class_2561.method_43469((String)"gui.jade.save_profile.message", (Object[])new Object[]{this.normalTitle}), (class_2561)class_2561.method_43471((String)"gui.continue"), (class_2561)class_2561.method_43471((String)"gui.cancel")));
            }).method_46437(48, 20).method_46431(), 52);
            this.addMessage(SAVE.getString());
        }

        public void refresh() {
            WailaConfig.Root root = Jade.rootConfig();
            boolean current = this.index == root.profileIndex;
            this.title = current ? this.normalTitle.method_27661().method_10852((class_2561)class_2561.method_43471((String)"gui.jade.profile.active")) : this.normalTitle;
            if (!root.isEnableProfiles()) {
                return;
            }
            for (class_339 widget : this.widgets) {
                widget.field_22763 = !current;
            }
        }
    }
}

