/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorNativeImage;
import java.awt.Rectangle;
import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_4093;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.ApiStatus;

public final class UIExternalTexture
extends UITexture
implements Closeable {
    static final String THREAD_NAME = TCDCommons.getModID() + ":" + UIExternalTexture.class.getSimpleName().toLowerCase();
    @ApiStatus.Internal
    static final ExecutorService SCHEDULER = Executors.newCachedThreadPool(runnable -> {
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });
    public static final UITexture FALLBACK_TEXTURE = new UITexture(TDrawContext.TEXTURE_ICONS, new Rectangle(0, 0, 64, 64));
    @Deprecated(since="3.7", forRemoval=true)
    public static final Cache<Object, UIExternalTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(32L).build();
    private boolean isClosed = false;
    private final class_1060 textureManager;
    private final class_1011 nativeImage;
    private final class_1043 nativeImageBackedTexture;
    private static long nextTexId;

    public UIExternalTexture(class_1011 image) throws NullPointerException, IllegalStateException {
        super(UIExternalTexture.generateTextureIdentifier());
        this.nativeImage = Objects.requireNonNull(image);
        this.nativeImageBackedTexture = new class_1043(this.nativeImage);
        this.textureManager = TCDCommonsClient.MC_CLIENT.method_1531();
        this.textureManager.method_4616(this.getTextureID(), (class_1044)this.nativeImageBackedTexture);
    }

    @Override
    public final void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.textureManager.method_4615(this.getTextureID());
        this.nativeImage.close();
    }

    protected final void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final int getNativeWidth() {
        return this.nativeImage.method_4307();
    }

    public final int getNativeHeight() {
        return this.nativeImage.method_4323();
    }

    public final int getNativeColor(int x, int y) throws IllegalArgumentException {
        return ((AccessorNativeImage)this.nativeImage).getColor(x, y);
    }

    private static final class_2960 generateTextureIdentifier() {
        UUID uuid = UUID.randomUUID();
        String uid = String.format("%s_%s_%s_%s", Long.toString(System.currentTimeMillis()), Long.toString(++nextTexId), Long.toString(uuid.getMostSignificantBits()), Long.toString(uuid.getLeastSignificantBits()));
        return class_2960.method_60655((String)TCDCommons.getModID(), (String)(UIExternalTexture.class.getSimpleName().toLowerCase(Locale.ENGLISH) + "/" + uid));
    }

    @ApiStatus.Experimental
    public static final void loadTextureAsync(byte[] pngBytes, Consumer<UIExternalTexture> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(pngBytes);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        SCHEDULER.submit(() -> {
            UIExternalTexture existing = (UIExternalTexture)TEXTURE_CACHE.getIfPresent((Object)pngBytes);
            if (existing != null) {
                TCDCommonsClient.MC_CLIENT.method_40000(() -> onReady.accept(existing));
                return;
            }
            try {
                class_1011 nImage = class_1011.method_49277((byte[])pngBytes);
                TCDCommonsClient.MC_CLIENT.method_40000(() -> {
                    UIExternalTexture eTex = new UIExternalTexture(nImage);
                    TEXTURE_CACHE.put((Object)pngBytes, (Object)eTex);
                    onReady.accept(eTex);
                });
            }
            catch (Exception e) {
                TCDCommonsClient.MC_CLIENT.method_40000(() -> onError.accept(e));
            }
        });
    }

    @Deprecated(since="3.7", forRemoval=true)
    public static final void loadTextureAsync(URL textureUrl, class_4093<?> minecraftClientOrServer, Consumer<UIExternalTexture> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(textureUrl);
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        String cacheKey = textureUrl.toString().toLowerCase();
        UIExternalTexture cached = (UIExternalTexture)TEXTURE_CACHE.getIfPresent((Object)cacheKey);
        if (cached != null && !cached.isClosed()) {
            minecraftClientOrServer.method_40000(() -> onReady.accept(cached));
            return;
        }
        Callable<class_1011> nis = () -> {
            byte[] pngEntity = HttpUtils.httpGetSyncB(new URI(textureUrl.toString()), new Header[]{new BasicHeader("Accept", "image/png")});
            return class_1011.method_49277((byte[])pngEntity);
        };
        UIExternalTexture.loadTextureAsync(nis, minecraftClientOrServer, (UIExternalTexture tex) -> {
            TEXTURE_CACHE.put((Object)cacheKey, tex);
            onReady.accept((UIExternalTexture)tex);
        }, onError);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public static final void loadTextureAsync(Callable<class_1011> nativeImageSupplier, class_4093<?> minecraftClientOrServer, Consumer<UIExternalTexture> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(nativeImageSupplier);
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        AtomicReference<Object> raisedException = new AtomicReference<Object>(null);
        SCHEDULER.submit(() -> {
            class_1011 nativeImage = null;
            try {
                nativeImage = (class_1011)nativeImageSupplier.call();
            }
            catch (Exception exc) {
                raisedException.set(exc);
            }
            class_1011 finalImage = nativeImage;
            minecraftClientOrServer.method_40000(() -> {
                if (finalImage != null) {
                    result.set(new UIExternalTexture(finalImage));
                }
                if (result.get() == null && raisedException.get() == null) {
                    raisedException.set(new UnsupportedOperationException());
                }
                if (raisedException.get() != null) {
                    onError.accept((Exception)raisedException.get());
                } else {
                    onReady.accept((UIExternalTexture)result.get());
                }
            });
        });
    }

    static {
        TaskScheduler.schedulePeriodicCacheCleanup(TEXTURE_CACHE);
        nextTexId = 0L;
    }
}

