#version 150


// from #moj_import <fog.glsl>
vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    if (vertexDistance <= fogStart) {
        return inColor;
    }

    float fogValue = vertexDistance < fogEnd ? smoothstep(fogStart, fogEnd, vertexDistance) : 1.0;
    return vec4(mix(inColor.rgb, fogColor.rgb, fogValue * fogColor.a), inColor.a * (1.0 - fogValue));
}

// -----------------------------------------------

float saturate(float i) {
    return clamp(i, 0.0, 1.0);
}

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec3 normal;
in vec3 worldViewDir;

out vec4 fragColor;

float fresnelEffect(vec3 normal, vec3 viewDir, float power) {
    return pow((1.0 - clamp(dot(normalize(normal), normalize(viewDir)), 0.0, 1.0)), power);
}

void main() {
    float textureR = texture(Sampler0, texCoord0).r;
    vec4 highlightColor = vertexColor;
    vec4 dimColor = vertexColor * 0.5;

    float highlight = smoothstep(0.5, 1.0, textureR);

    float fresnel = max(saturate(smoothstep(-0.4, 1.0, fresnelEffect(normal, worldViewDir, 0.5))), 0.17);

    vec4 color = clamp(mix(dimColor, highlightColor, highlight) * fresnel * textureR, vec4(0.0), vec4(1.0));
    color.a = saturate(color.a - 0.05);
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
