/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.slot;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.network.ContainerSlotsHack;
import dev.gigaherz.toolbelt.slot.BeltAttachment;
import dev.gigaherz.toolbelt.slot.BeltSlot;
import java.util.List;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BeltSlotMenu
extends RecipeBookMenu<CraftingInput, CraftingRecipe> {
    private final BeltSlot slotBelt;
    private final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer resultSlots = new ResultContainer();
    private final Player owner;

    public BeltSlotMenu(int id, Inventory playerInventory) {
        super((MenuType)ToolBelt.BELT_SLOT_MENU.get(), id);
        this.owner = playerInventory.player;
        this.addSlot((Slot)new ResultSlot(playerInventory.player, this.craftSlots, (Container)this.resultSlots, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)this.craftSlots, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            EquipmentSlot equipmentslot = InventoryMenu.SLOT_IDS[k];
            ResourceLocation resourcelocation = (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(equipmentslot);
            this.addSlot((Slot)new ArmorSlot((Container)playerInventory, (LivingEntity)this.owner, equipmentslot, 39 - k, 8, 8 + k * 18, resourcelocation));
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.addSlot(new Slot((Container)playerInventory, 40, 77, 62){

            public void setByPlayer(ItemStack p_270479_, ItemStack p_299920_) {
                BeltSlotMenu.this.owner.onEquipItem(EquipmentSlot.OFFHAND, p_299920_, p_270479_);
                super.setByPlayer(p_270479_, p_299920_);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        this.slotBelt = new BeltSlot(BeltAttachment.get((LivingEntity)playerInventory.player), 77, 44);
        this.addSlot(this.slotBelt);
        if (playerInventory.player.level().isClientSide) {
            PacketDistributor.sendToServer((CustomPacketPayload)ContainerSlotsHack.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void fillCraftSlotsStackedContents(StackedContents itemHelper) {
        this.craftSlots.fillStackedContents(itemHelper);
    }

    public void clearCraftingContent() {
        this.resultSlots.clearContent();
        this.craftSlots.clearContent();
    }

    public boolean recipeMatches(RecipeHolder<CraftingRecipe> recipe) {
        return ((CraftingRecipe)recipe.value()).matches((RecipeInput)this.craftSlots.asCraftInput(), this.owner.level());
    }

    public void slotsChanged(Container inventory) {
        Bridge.slotChangedCraftingGridAccessor((AbstractContainerMenu)this, this.owner.level(), this.owner, this.craftSlots, this.resultSlots, null);
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultSlots.clearContent();
        if (!player.level().isClientSide) {
            this.clearContainer(player, (Container)this.craftSlots);
            BeltFinder.sendSync(player);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remaining = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            int i;
            ItemStack slotContents = slot.getItem();
            remaining = slotContents.copy();
            EquipmentSlot equipmentslot = player.getEquipmentSlotForItem(remaining);
            if (index == this.slotBelt.index) {
                if (!this.moveItemStackTo(slotContents, 9, 45, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index == 0) {
                if (!this.moveItemStackTo(slotContents, 9, 45, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotContents, remaining);
            } else if (index >= 1 && index < 5 ? !this.moveItemStackTo(slotContents, 9, 45, false) : (index >= 5 && index < 9 ? !this.moveItemStackTo(slotContents, 9, 45, false) : (equipmentslot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(8 - equipmentslot.getIndex())).hasItem() ? !this.moveItemStackTo(slotContents, i = 8 - equipmentslot.getIndex(), i + 1, false) : (equipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(slotContents, 45, 46, false) : (this.slotBelt.mayPlace(slotContents) && !this.slotBelt.hasItem() ? !this.moveItemStackTo(slotContents, this.slotBelt.index, this.slotBelt.index + 1, false) : (index >= 9 && index < 36 ? !this.moveItemStackTo(slotContents, 36, 45, false) : (index >= 36 && index < 45 ? !this.moveItemStackTo(slotContents, 9, 36, false) : !this.moveItemStackTo(slotContents, 9, 45, false)))))))) {
                return ItemStack.EMPTY;
            }
            if (slotContents.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY, remaining);
            } else {
                slot.setChanged();
            }
            if (slotContents.getCount() == remaining.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotContents);
            if (index == 0) {
                player.drop(slotContents, false);
            }
        }
        return remaining;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slotIn) {
        return slotIn.container != this.resultSlots && super.canTakeItemForPickAll(stack, slotIn);
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return this.craftSlots.getWidth();
    }

    public int getGridHeight() {
        return this.craftSlots.getHeight();
    }

    public int getSize() {
        return 5;
    }

    public CraftingContainer getCraftSlots() {
        return this.craftSlots;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int slotIndex) {
        return slotIndex != this.getResultSlotIndex();
    }

    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.CRAFTING_SEARCH, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_MISC, RecipeBookCategories.CRAFTING_REDSTONE});
    }

    private static class Bridge
    extends CraftingMenu {
        private Bridge(int pContainerId, Inventory pPlayerInventory) {
            super(pContainerId, pPlayerInventory);
            throw new IllegalStateException("Not instantiable.");
        }

        public static void slotChangedCraftingGridAccessor(AbstractContainerMenu container, Level level, Player player, CraftingContainer craftingInventory, ResultContainer craftResultInventory, RecipeHolder<CraftingRecipe> recipeHolder) {
            CraftingMenu.slotChangedCraftingGrid((AbstractContainerMenu)container, (Level)level, (Player)player, (CraftingContainer)craftingInventory, (ResultContainer)craftResultInventory, recipeHolder);
        }
    }
}

