/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client.radial;

import dev.gigaherz.toolbelt.client.radial.DrawingContext;
import dev.gigaherz.toolbelt.client.radial.GenericRadialMenu;
import dev.gigaherz.toolbelt.client.radial.RadialMenuItem;
import java.util.Objects;
import net.minecraft.network.chat.Component;

public class TextRadialMenuItem
extends RadialMenuItem {
    private final Component text;
    private final int color;

    public Component getText() {
        return this.text;
    }

    public int getColor() {
        return this.color;
    }

    public TextRadialMenuItem(GenericRadialMenu owner, Component text) {
        super(owner);
        this.text = text;
        this.color = -1;
    }

    public TextRadialMenuItem(GenericRadialMenu owner, Component text, int color) {
        super(owner);
        this.text = text;
        this.color = color;
    }

    @Override
    public void draw(DrawingContext context) {
        String textString = this.text.getString();
        float x = context.x - (float)context.font.width(textString) / 2.0f;
        float f = context.y;
        Objects.requireNonNull(context.font);
        float y = f - 9.0f / 2.0f;
        context.graphics.drawString(context.font, textString, x, y, this.color, true);
    }

    @Override
    public void drawTooltips(DrawingContext context) {
    }
}

