/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IRenderHelpersNeoForge;
import org.cyclops.flopper.FlopperNeoForge;
import org.cyclops.flopper.blockentity.BlockEntityFlopperNeoForge;
import org.joml.Matrix4f;

public class RenderBlockEntityFlopperNeoForge
implements BlockEntityRenderer<BlockEntityFlopperNeoForge> {
    public RenderBlockEntityFlopperNeoForge(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityFlopperNeoForge tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            FluidStack fluid = tile.getTank().getFluid();
            IRenderHelpersNeoForge renderHelpers = FlopperNeoForge._instance.getModHelpers().getRenderHelpers();
            renderHelpers.renderFluidContext(fluid, matrixStack, () -> {
                float height = (float)fluid.getAmount() * 0.3125f / (float)tile.getTank().getCapacity() + 0.6875f;
                int brightness = Math.max(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = renderHelpers.getFluidIcon(tile.getTank().getFluid(), Direction.UP);
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                Triple color = FlopperNeoForge._instance.getModHelpers().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)tile.getLevel(), tile.getBlockPos()));
                VertexConsumer vb = buffer.getBuffer(RenderType.text((ResourceLocation)icon.atlasLocation()));
                Matrix4f matrix = matrixStack.last().pose();
                vb.addVertex(matrix, 0.125f, height, 0.125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
                vb.addVertex(matrix, 0.125f, height, 0.875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
                vb.addVertex(matrix, 0.875f, height, 0.875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
                vb.addVertex(matrix, 0.875f, height, 0.125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            });
        }
    }
}

