/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils.ranges;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.portingdeadmods.nautec.utils.ranges.AbstractRange;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class IntRange
extends AbstractRange<Integer> {
    public static final MapCodec<IntRange> MAP_CODEC = IntRange.rangeMapCodec(Codec.INT, IntRange::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, IntRange> STREAM_CODEC = IntRange.rangeStreamCodec(ByteBufCodecs.INT, IntRange::new);

    protected IntRange(int min, int max) {
        super(min, max);
    }

    @Override
    protected Collection<Integer> collectPossibleValues() {
        IntArrayList values = new IntArrayList(Math.abs((Integer)this.getMax() - (Integer)this.getMin()) + 1);
        for (int i = ((Integer)this.getMin()).intValue(); i < (Integer)this.getMax(); ++i) {
            values.add(i);
        }
        return ImmutableList.copyOf((Collection)values);
    }

    public static IntRange of(int min, int max) {
        return new IntRange(min, max);
    }
}

