/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.nautec.utils;

import com.portingdeadmods.nautec.Nautec;
import com.portingdeadmods.nautec.api.bacteria.Bacteria;
import com.portingdeadmods.nautec.api.bacteria.BacteriaInstance;
import com.portingdeadmods.nautec.utils.BacteriaHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;

public final class GuiUtils {
    public static final ResourceLocation BACTERIA = Nautec.rl("item/petri_dish_overlay");

    public static void renderBacteria(GuiGraphics guiGraphics, BacteriaInstance instance, int x, int y) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(BACTERIA);
        if (!instance.isEmpty()) {
            Bacteria bacteria = BacteriaHelper.getBacteria((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), instance.getBacteria());
            int color = bacteria.stats().color();
            int r = FastColor.ARGB32.red((int)color);
            int g = FastColor.ARGB32.green((int)color);
            int b = FastColor.ARGB32.blue((int)color);
            int a = FastColor.ARGB32.alpha((int)color);
            guiGraphics.blit(x + 1, y, 0, 16, 16, sprite, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        }
    }

    public static boolean isHovering(GuiGraphics guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        return guiGraphics.containsPointInScissor(mouseX, mouseY) && mouseX > x && mouseY > y && mouseX < x + width && mouseY < y + height;
    }
}

